#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
#    Copyright (C) 2011  Stefano Palazzo <stefano.palazzo@gmail.com>
#                  2011  Mark Tully <markjtully@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from gi.repository import Gio
from gi.repository import Gtk

import urllib
import urllib2
import gzip
import cStringIO
import json
import functools
import random
import gettext

EVERYTHING = 0
OFFICIAL = 1
COMMUNITY = 2
TECHNICAL = 3
TAGS = 4

_ = gettext.gettext

DEFAULT_SITE = "askubuntu.com"
SE_API_KEY = "BmtlCGm1UU-Cmn8FAvfT4Q"
NUMS = "0123456789"
SITES = (
    ("stackoverflow", "stackoverflow.com", "Stack Overflow"),
    ("@serverfault", "serverfault.com", "Server Fault"),
    ("@superuser", "superuser.com", "Super User"),
    ("@webapps", "webapps.stackexchange.com", "Web Applications"),
    ("@gaming", "gaming.stackexchange.com", "Gaming"),
    ("@webmasters", "webmasters.stackexchange.com", "Webmasters"),
    ("@cooking", "cooking.stackexchange.com", "Cooking"),
    ("@gamedev", "gamedev.stackexchange.com", "Game Development"),
    ("@photo", "photo.stackexchange.com", "Photography"),
    ("@stats", "stats.stackexchange.com", "Statistical Analysis"),
    ("@math", "math.stackexchange.com", "Mathematics"),
    ("@diy", "diy.stackexchange.com", "Home Improvement"),
    ("@gis", "gis.stackexchange.com", "GIS"),
    ("@tex", "tex.stackexchange.com", "TeX - LaTeX"),
    ("@askubuntu", "askubuntu.com", "Ask Ubuntu"),
    ("@money", "money.stackexchange.com", "Personal Finance and Money"),
    ("@english", "english.stackexchange.com", "English Language and Usage"),
    ("@stackapps", "stackapps.com", "Stack Apps"),
    ("@ux", "ux.stackexchange.com", "User Experience"),
    ("@unix", "unix.stackexchange.com", "Unix and Linux"),
    ("@wordpress", "wordpress.stackexchange.com", "WordPress"),
    ("@cstheory", "cstheory.stackexchange.com", "Theoretical Computer Science"),
    ("@apple", "apple.stackexchange.com", "Apple"),
    ("@rpg", "rpg.stackexchange.com", "Role-playing Games"),
    ("@bicycles", "bicycles.stackexchange.com", "Bicycles"),
    ("@programmers", "programmers.stackexchange.com", "Programmers"),
    ("@electronics", "electronics.stackexchange.com", "Electrical Engineering"),
    ("@android", "android.stackexchange.com", "Android Enthusiasts"),
    ("@answers.onstartups", "answers.onstartups.com", "OnStartups"),
    ("@boardgames", "boardgames.stackexchange.com", "Board and Card Games"),
    ("@physics", "physics.stackexchange.com", "Physics"),
    ("@homebrew", "homebrew.stackexchange.com", "Homebrewing"),
    ("@security", "security.stackexchange.com", "IT Security"),
    ("@writers", "writers.stackexchange.com", "Writers"),
    ("@avp", "avp.stackexchange.com", "Audio-Video Production"),
    ("@graphicdesign", "graphicdesign.stackexchange.com", "Graphic Design"),
    ("@dba", "dba.stackexchange.com", "Database Administrators"),
    ("@scifi", "scifi.stackexchange.com", "Science Fiction and Fantasy"),
    ("@codereview", "codereview.stackexchange.com", "Code Review"),
    ("@codegolf", "codegolf.stackexchange.com", "Code Golf"),
    ("@quant", "quant.stackexchange.com", "Quantitative Finance"),
    ("@pm", "pm.stackexchange.com", "Project Management"),
    ("@skeptics", "skeptics.stackexchange.com", "Skeptics"),
    ("@fitness", "fitness.stackexchange.com", "Physical Fitness"),
    ("@drupal", "drupal.stackexchange.com", "Drupal Answers"),
    ("@mechanics", "mechanics.stackexchange.com", "Motor Vehicle Maintenance and Repair"),
    ("@parenting", "parenting.stackexchange.com", "Parenting"),
    ("@sharepoint", "sharepoint.stackexchange.com", "SharePoint"),
    ("@music", "music.stackexchange.com", "Musical Practice and Performance"),
    ("@sqa", "sqa.stackexchange.com", "Software Quality Assurance and Testing"),
    ("@judaism", "judaism.stackexchange.com", "Mi Yodeya"),
    ("@german", "german.stackexchange.com", "German Language and Usage"),
    ("@japanese", "japanese.stackexchange.com", "Japanese Language and Usage"),
    ("@philosophy", "philosophy.stackexchange.com", "Philosophy"),
    ("@gardening", "gardening.stackexchange.com", "Gardening and Landscaping"),
    ("@travel", "travel.stackexchange.com", "Travel"),
    ("@productivity", "productivity.stackexchange.com", "Personal Productivity"),
    ("@crypto", "crypto.stackexchange.com", "Cryptography"),
    ("@dsp", "dsp.stackexchange.com", "Signal Processing"),
    ("@french", "french.stackexchange.com", "French Language and Usage"),
    ("@christianity", "christianity.stackexchange.com", "Christianity"),
    ("@bitcoin", "bitcoin.stackexchange.com", "Bitcoin"),
    ("@linguistics", "linguistics.stackexchange.com", "Linguistics"),
    ("@hermeneutics", "hermeneutics.stackexchange.com", "Biblical Hermeneutics"),
    ("@history", "history.stackexchange.com", "History"),
    ("@bricks", "bricks.stackexchange.com", "LEGO® Answers"),
    ("@spanish", "spanish.stackexchange.com", "Spanish Language and Usage"),
    ("@scicomp", "scicomp.stackexchange.com", "Computational Science"),
    ("@movies", "movies.stackexchange.com", "Movies and TV"),
    ("@chinese", "chinese.stackexchange.com", "Chinese Language and Usage"),
    ("@biology", "biology.stackexchange.com", "Biology"),
    ("@poker", "poker.stackexchange.com", "Poker"),
    ("@mathematica", "mathematica.stackexchange.com", "Mathematica"),
    ("@cogsci", "cogsci.stackexchange.com", "Cognitive Sciences"),
    ("@outdoors", "outdoors.stackexchange.com", "The Great Outdoors"),
    ("@smugmug", "smugmug.stackexchange.com", "SmugMug"),
    ("@martialarts", "martialarts.stackexchange.com", "Martial Arts"),
    ("@sports", "sports.stackexchange.com", "Sports"),
    ("@academia", "academia.stackexchange.com", "Academia"),
    ("@cs", "cs.stackexchange.com", "Computer Science"),
    ("@workplace", "workplace.stackexchange.com", "The Workplace"),
    ("@windowsphone", "windowsphone.stackexchange.com", "Windows Phone"),
    ("@chemistry", "chemistry.stackexchange.com", "Chemistry"),
    ("@chess", "chess.stackexchange.com", "Chess"),
    ("@libraries", "libraries.stackexchange.com", "Libraries and Information Science"),
    ("@makers", "makers.stackexchange.com", "Personal Manufacturing"),
)


def memoize_infinitely(function):
    """ Caches results of certain functions to improve performance
    """
    cache = {}

    @functools.wraps(function)
    def wrapped(*args):
        """ Adds the args to the cache
        """
        if not args in cache:
            cache[args] = function(*args)
        return cache[args]
    return wrapped


def get_api_data(query, site=DEFAULT_SITE):
    """ Checks if askubuntu is being searched and if it is, decides which
    askubuntu mirror to do the search on.  Also performs the search.
    Args:
      query: the search string
      site: the site to be searched
    Returns:
      A json object containing the search results
    """
    print "api.%s/\33[1;31m%s\33[m" % (site, query)
    if query.startswith("similar?title") and site == "askubuntu.com":
        try:
            # Check to see if we can ping the local data server running on
            # port 19115
            try:
                result = json.loads(urllib2.urlopen(
                    "http://localhost:19115/%s" % query.replace(" ", "%20"),
                    timeout=0.2).read())
                print "\33[1mused local service\33[m"
                return result
            except Exception as e:
                if random.random() > 0.5:
                    result = json.loads(urllib2.urlopen(
                        "http://50.19.108.78:8080/%s" % query.replace(" ", "%20"),
                        timeout=0.5).read())
                    print "\33[1mused ec2 service\33[m"
                else:
                    result = json.loads(urllib2.urlopen(
                        "http://audata.quickmediasolutions.com:8046/%s" % query.replace(" ", "%20"),
                        timeout=0.5).read())
                    print "\33[1mused AU Data Server service\33[m"
                return result
        except Exception as e:
            print "\33[1;31m%s\33[m" % repr(e)
    try:
        query = query.replace(" ", "%20")
        site = "api." + site if site != "stackauth.com" else site
        url = "http://%s/1.0/%s" % (site, query)
        url += ("&key=%s" if "?" in url else "?key=%s") % SE_API_KEY
        response = urllib.urlopen(url)
        print "API Calls:", ' / '.join(i.split()[1].strip() for i in
            str(response.headers).split("\n")[4:6][::-1])
        response = response.read()
        return json.load(gzip.GzipFile(fileobj=cStringIO.StringIO(response)))
    except IOError, e:
        print repr(e)
        return []


def detect_site(search):
    """
    Args:
      search: the search (contains the site and search string)
    Returns:
      The site and the search string
    """
    site = DEFAULT_SITE
    sitemodifier = " "
    for modifier, url, sitename in SITES:
        if search.startswith(modifier):
            search = search.replace(modifier, "").strip()
            site = url
            sitemodifier = modifier[1:]
    return site, search, sitemodifier


def get_questions(search):
    """ Gets questions matching the search from the relevant stackexchange site
    Args:
      search: the search string
    Returns:
      url: the question's url
      icon: the question's icon (based on the solved state of the question)
      title: the question's title
      text: The question's vote count and/or no of answers depending on its solved status
      category: The question's category (solved, answered or unanswered)
    """
    already_seen = []
    site, search, modifier = detect_site(search)
    search += " "  # Hack: Makes SE return questions for a single-word query
    data = get_api_data("similar?&pagesize=30&title=%s" % search, site)
    if data and "questions" in data:
        for i in data['questions']:
            # Filter out resuts marked as [Closed]
            if "closed_date" in i:
                continue
            if "question_id" in i and "title" in i:
                _id = i['question_id']
                if _id not in already_seen:
                    url = "http://%s/questions/%d" % (site, _id)
                    title = i['title']
                    votetext = str(i['up_vote_count'] - i['down_vote_count'])
                    if (i['up_vote_count'] - i['down_vote_count']) == 1:
                        votetext += _(" vote")
                    else:
                        votetext += _(" votes")
                    category = COMMUNITY
                    if i['answer_count'] >= 1:
                        icon = Gio.ThemedIcon.new("/usr/lib/unity-lens-help/icons/askubuntu-unsolved-coloured.svg").to_string()
                        answertext = str(i["answer_count"])
                        if i["answer_count"] == 1:
                            answertext += _(" answer")
                        else:
                            answertext += _(" answers")
                        text = votetext + ", " + answertext
                    else:
                        icon = Gio.ThemedIcon.new("/usr/lib/unity-lens-help/icons/askubuntu-question-coloured.svg").to_string()
                        text = votetext

                    if "accepted_answer_id" in i:
                        icon = Gio.ThemedIcon.new("/usr/lib/unity-lens-help/icons/askubuntu-answer-coloured.svg").to_string()
                        text = _("%s, 1 accepted answer" % votetext)

                    try:
                        tags = i['tags'][:2]
                        for tag in tags:
                            icon_theme = Gtk.IconTheme()
                            icon_info = icon_theme.lookup_icon(tag, 128, 0)
                            if icon_info:
                                icon = Gio.ThemedIcon.new(tag).to_string()
                                continue
                    except:
                        pass

                    # For stackexchange sites, use their icon
                    if not site == DEFAULT_SITE:
                        category = COMMUNITY
                        icon = Gio.ThemedIcon.new('http://cdn.sstatic.net/%s/img/apple-touch-icon.png' % modifier).to_string()

                    yield url, icon, title, text, category
                    already_seen.append(_id)


@memoize_infinitely
def get_tags(search):
    """ Gets tags matching the search from the relevant stackexchange site
    Args:
      search: the search string
    Returns:
      result: Contains the tag's url and title
    """
    site, search, modifier = detect_site(search)
    for search in search.split():  # this is _BA-AD_ for long searches
        if not all(i in NUMS for i in search):
            data = get_api_data(
                "tags?filter=%s&pagesize=10" % search, site)
            result = []
            if "tags" in data:
                for i in data['tags']:
                    url = "http://%s/tags/%s" % (site, i['name'])
                    result.append([url, i['name']])
            return result
