#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>

#include <string.h>
#include <unistd.h>


/* thx aramosf@unsec.net for the nice regexp! */

// Linux
char tcpcommand[]= "netstat -tan | sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;
char udpcommand[]= "netstat -uan | sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;



// OpenBSD
// char tcpcommand[]= "netstat -an -p tcp | sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;
// char udpcommand[]= "netstat -an -p udp| sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;


// Solaris
// char tcpcommand[]= "netstat -an -P tcp | sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;
// char udpcommand[]= "netstat -an -P udp| sed -e '/[\\.:][0-9]/!d' -e 's/.*[\\.:]\\([0-9]*\\) .*[\\.:].*/\\1/'" ;



void checkport(int port, char command[]) {
	
	int statusfile;
	int statcommand;
	int ok = 0;
	char ports[30];
	char compare[100];
	
	FILE *fich_tmp ;
	
	fich_tmp=popen (command, "r") ;
	
	
	while (!feof(fich_tmp) && ok == 0) {
		
		fgets(ports, 30, fich_tmp);
		
		sprintf(compare,"%i\n",port);
		
		if (strcmp(ports, compare) == 0) {ok = 1;}
		
		
        }
	
	pclose(fich_tmp);
	
	if ( ok == 0 ) {
		
		printf ("Found Hidden port that not appears in netstat: %i\n", port) ;
			
	}		
	
}


int main() {
	
	
	int i ;
	int u ;
	
	printf ("Unhide 20080519 \n") ;
	printf ("yjesus@security-projects.com\n\n\n") ;
	
	
	printf ("Starting TCP checking\n\n") ;
	
	for (i =1; i < 65535; i++) {
	
		int socket_desc;
		struct sockaddr_in address;
		

		socket_desc=socket(AF_INET,SOCK_STREAM,0);

		address.sin_family = AF_INET;
		address.sin_addr.s_addr = INADDR_ANY;
		address.sin_port = htons(i);
		errno= 0 ;
		bind(socket_desc,(struct sockaddr *)&address,sizeof(address));
		listen(socket_desc,1);
  
		if ( errno != 0) {
	
			close(socket_desc);

			checkport(i, tcpcommand);
		
		}
		
		close(socket_desc);
	}
	
	printf ("Starting UDP checking\n\n") ;
	
	
	for (u =1; u < 65535; u++) {
	
		int socket_desc;
		struct sockaddr_in address;
		

		socket_desc=socket(AF_INET,SOCK_DGRAM,0);

		address.sin_family = AF_INET;
		address.sin_addr.s_addr = INADDR_ANY;
		address.sin_port = htons(u);
		errno= 0 ;
		bind(socket_desc,(struct sockaddr *)&address,sizeof(address));
  
		if ( errno != 0) {
	
			close(socket_desc);
			
			checkport(u, udpcommand);
		
		}
		
		close(socket_desc);
	}
	
}

