/***************************************************************************
                                   Mwindow.h
                              -------------------
 
     Begin        : Sat Oct 23 2007 10:00 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the main windows
 
****************************************************************************/

#ifndef INCLUDE_MWINDOW_H
#define INCLUDE_MWINDOW_H

#include <QDialog>
#include <QDropEvent>
#include <QTimer>
#include <QtGui>
#include <QFileIconProvider>
#include <QList>
#include <QShortcut>

#include "ui_main_window.h"
#include "AddFolder.h"
#include "CopyThread.h"
#include "FEwindow.h"
#include "Ewindow.h"
#include "spaceWindow.h"
#include "WriteThread.h"
#include "env.h"

#ifdef ULTRACOPIER_MODE_KDE4
#include <kfiledialog.h>
#include <KUrl>
#endif

#ifdef Q_OS_WIN32
#include <windows.h>
#endif

class AddFolderThread;

typedef struct {
	quint64 id;
	QTreeWidgetItem *theGraphicIndex;
} copyItemExternal;

/** \brief The copy window

This window is the main windows for that's user interact with the copy. And for show the copy information.
*/
class Main_window : public QDialog, public Ui::main_window
{
	Q_OBJECT
public:
	Main_window();
	~Main_window();
	//set the moving mode
	void setMovingMode(bool isMovingMode);
	//set the argument of the source and destination
	void setArguments(QStringList argumentsUltracopier);
	//get the main destination, can be "" for unable to stat the mount point, "*" for multiple destination
	QString getMainDestination();
	//get the main source, can be "" for unable to stat the mount point, "*" for multiple destination
	QString getMainSource();
	//get the moving mode
	bool getMovingMode();
	//can be deleted
	bool canByDeleted();
public slots:
	//click on the cancel button or query the cancel button
	void cancel_copy_window();
	//add item to list
	void addToList(const QFileInfo& source,const QFileInfo& destination);
	//update the style
	void UpdateStyle();
	//add one entry to dir list
	void addEntryToDirList(QDir theDir);
	//if addFolderThread detect that the source folder are same as destination folder
	void AddFolderDetectAreSame(const QString& folder);
	//Listing is finish
	void ListingIsFinish();
	//function for copy thread error
	void copyThreadError(const int buttonActivated,const QString& file,const QString& errorString,quint64 id);
	//function for write thread error
	void writeThreadError(const int buttonActivated,const QString& file,const QString& errorString,quint64 id);
	//function for fileIsSame
	void copyThreadFileIsSame(const QString& file);
	//function for fileIsExists
	void copyThreadFileIsExists(const QString& source,const QString& destination);
	//update the play, pause,skip button
	void updatePlayPauseSkipButton();
	//update the progressBar_all mode (busy or not)
	void updateProgressBarAllMode();
signals:
        /// \brief Signal for query the style update
        void OrderUpdateStyle();
	/// \brief emit a list of url for listing
	void setQListOfDrop(QList<QUrl> url);
	//for resume the copy
	void resumeCopy();
	//for send signal when the copy is finish and window not closed
	void copyFinish();
	//can delete the object
	void canDeleteTheObject();
private slots:
	//copy thread or write thread is finish
	void copyThreadOrWriteThread();
	//search update
	void on_lineEditSearch_textChanged(QString );
	//search validate
	void on_lineEditSearch_returnPressed();
	//search next
	void on_pushButtonSearchNext_clicked();
	//search prev
	void on_pushButtonSearchPrev_clicked();
	//if the more button is pressed or not
	void on_pushButtonSaveErrorToFile_clicked();
	void resizeMore(bool moreButton);
	//add file to the copy list
	bool addFile();
	//add folder to copy list
	bool addFolder();
	//delete the selected file
	bool Playlist_management_del();
	//put selected file on top
	void Playlist_management_putSelectedFileOnTop();
	//move up the selected file
	void Playlist_management_putSelectedFileUp();
	//move down the selected file
	void Playlist_management_putSelectedFileDown();
	//put the selected file on bottom
	void Playlist_management_putSelectedFileOnBottom();
	//click on the pause button
	void PauseButton();
	//push the skip button
	void SkipButton();
	//reset the options as default
	void setDefaultOptions();
	//update the copy stat and the progress bar and copy speed
	void updateTheCopyStat();
	//show the file exist windows and return the choise
	//if sameFile == true : text1 = source and dest
	//if sameFile == false : text1 = path : text2 = source : text3 = dest
	int GetActionFileExist(bool sameFile,const QString& text1,const QString& text2="",const QString& text3="");
	//set action in window error
	void GetAction(int action);
	//get speed
	void abstractLayerGetSpeed();
	//update the speed type
	void abstractLayerUpdateSpeedType();
	//change the priority
	void changePriority();
	//change show status
	void changeShowStatusBar();
	//For catch an action on the systray icon
	void CatchAction(QSystemTrayIcon::ActivationReason reason);
	//Restore the window
	void RestoreTheWindow();
	//update the block size value
	void updateBlockSize(int newBlockSize=64);
	//set prealoc file size
	void setPreallocateFileSize(int checked);
	//manage error in listing
	void ErrorInListing(const QString& folder,const QString& theError);
	//update the copy speed
	void updateTheCopySpeed();
	//update the time remaning
	void updateTheTimeRemaining();
	//close the search box
	void closeTheSearchBox();
	//search box shortcut
	void searchBoxShortcut();
	//hilight the search
	void hilightTheSearch();
	//when the copy thread is finish
	void copyThreadIsFinish();
	#if (DEBUG_ULTRACOPIER>0)
	void DebugCheckThread();
	#endif
private:
	QMenu			*menu;				///< The add menu
	QMenu			*systrayMenu;			///< The sysrray icon menu
	QAction			*actionaddFile;			///< Add menu
	QAction			*actionaddFolder;		///< Add folder
	QAction			*actionPause;			///< Add pause menu
	QAction			*actionRestore;			///< Add restore menu
	QAction			*actionQuit;			///< Add quit menu
	AddFolderThread		*AddingFolderThread;		///< Pointer on the listing folder thread
	copyThread		*CopyThread;			///< Pointer on the copy thread
	qint64			sizeTot;			///< Size of all the files should be copied
	qint64			sizeCur;			///< Size of the current file
	qint64			fileTot;			///< Number of file in the playlist
	bool			aErrorHasOccurred;		///< For store if error is occured
	QShortcut		*searchShortcut;		///< For search shortcut
	QShortcut		*searchShortcut2;		///< For search shortcut

	QTimer			*TimerForCopyUpdate;		///< For update the copy information or/and systray icon
	QTimer			*TimerForCopySpeedUpdate;	///< For update the copy speed update
	QTimer			*TimerForTimeRemainingUpdate;	///< For update the time remaning update
	QTimer			*TimerForSearch;		///< For update the search
	QTime			showingDrop;			///< For drop frame
	QTime			addDirDropFrame;		///< For drop frame when adding folders
	QList<QTreeWidgetItem*> addingBuffer;			///< Buffer for add block item
	int			MaxSpeedValueInt;		///< Max speed of the copy
	int			currentIndexSearch;		///< Current index search in starting at the end

	bool			movingMode;			///< Flag for set if is in moving mode
	QThread::Priority	priorityLevel;			///< For store the child thread priority level
	bool			showTheStatus;			///< Flag for know if it need show the status

	QList<QUrl>		listUrlEvent;			///< List of events
	QSystemTrayIcon*	sysTrayIcon;			///< Icon in the systray for show the progression
	QPixmap			*pixmapTop;			///< For store the name of the top image
	QPixmap			*pixmapBottom;			///< For store the name of the bottom image
	int			getOldProgression;		///< For store the old progression information
	QString			LastDestination;		///< Store Last destination for check free space after size calculating
	int			actionInDialog;			///< For send action from windows
	quint64			autoIncrementId;		///< Generate unique item id
	QList<copyItemExternal> theCopyItemExternal;
	QString			MainDestination;		///< For store the main destination as string
	QString			MainSource;			///< For store the main source as string
	bool			shouldBeClosed;			///< For store when the windows should be closed
	int			numberOfFilePutAtTheEnd;	///< For prevent infinity loop  with action "end of"

	#if (DEBUG_ULTRACOPIER>0)
	QTimer			DebugTrackThread;
	QHBoxLayout		*hboxLayoutDebug;
	QLabel			*Debug_label_copyThread;
	QLabel			*Debug_label_writeThread;
	QLabel			*Debug_label_waitThread;
	QString			graphicPointer(QTreeWidgetItem * theItem);
	#endif

	#ifdef Q_OS_WIN32
	HWND			SpecWindowsCurWindow;		///< For do progressbar in systray for the current window under vista, seven
	#endif

	//open window for the user choise the directory
	QString getDirectoryPath(const QString& title);
	//open window error management
	int errorManagement(int ButtonActivated,const QString& fileOrDir,const QString& errorMessage);
	//update the text at the end of the copy of file
	void updateFileOverAllProgression();
	//cut the long text
	QString cutText(QString in,int len);
	//set speed
	void abstractLayerSetSpeed(int speed);
	//update the slider speed text
	void UpdateSliderSpeedText();
	//close query by the system
	void closeEvent(QCloseEvent * event);
	//Priority conversion
	QThread::Priority priorityFromInt(int num);
	//set visibility status of the copy
	void setVisibleStatus(bool show);
	//Create progessive icon
	QIcon dynaIcon(int percent=-1,QString text="");
	//drag event processing
	void dropEvent(QDropEvent *event);
	//drag event
	void dragEnterEvent(QDragEnterEvent *event);
	//Set the status of the copy
	void setStatusOfCopy();
	//set destination only on internal
	void setInternalDestination(QString dir);
	//set source only on internal
	void setInternalSource(QString dir);
	//remove id
	void removeIdItem(quint64 id);
};

#endif
