#include <stdlib.h>		// exit(), EXIT_SUCCESS, EXIT_FAILURE

#ifdef _WIN32
#include <io.h>
#include <windows.h>
#include <winsock.h>
#else
#include <unistd.h>
#endif

// uget
#include <ug_ipc.h>

static gpointer client_thread (gpointer);

int main (int argc, char* argv[])
{
	GMainLoop*	loop;
	UgIpc		ipc;

#ifdef _WIN32
	//	curl_global_init() will do this
	WSADATA WSAData;

	WSAStartup (MAKEWORD (2, 2), &WSAData);
#endif

	// glib
	if (g_thread_supported () == FALSE)
		g_thread_init (NULL);
//	if (g_module_supported () == FALSE)
//		return FALSE;

	loop = g_main_loop_new (NULL, FALSE);
	ug_ipc_init_server (&ipc);

	g_thread_create ((GThreadFunc)client_thread, NULL, FALSE, NULL);

	g_main_loop_run (loop);

#ifdef _WIN32
	WSACleanup ();
#endif

	return EXIT_SUCCESS;		// EXIT_SUCCESS == 0
}


static gpointer client_thread (gpointer data)
{
	UgIpc	ipc;
	gint	n;
	gchar*	string = "http://test.org/index.htm";

	ug_ipc_init_client (&ipc);

	for (n=0; n < 3; n++) {
#ifdef _WIN32
		Sleep (500);	// millisecond
#else
		usleep (500 * 1000);	// u_second
#endif

		if (ug_ipc_ping (&ipc) == FALSE)
			g_print ("Ping fail\n");
		else {
			g_print ("Ping ok\n");
			ug_ipc_send (&ipc, 1, &string);
		}
	}
	ug_ipc_finalize (&ipc);

	return NULL;
}

