/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

/*
 * This is a fragment, included from multiple places in ebwt_search.cpp.
 * It implements the logic of the exact-search routine.  It is
 * implemented as a code fragment so that it can be reused in both
 * paired and unpaired alignment.
 */
{
	uint32_t plen = length(patsrc->bufa().patFw);
	if(!nofw) {
		// Match against forward strand
		params.setFw(true);
		bt.setQuery(patsrc->bufa());
		bt.setOffs(0, 0, plen, plen, plen, plen);
		// If we matched on the forward strand, ignore the reverse-
		// complement strand
		if(bt.backtrack()) {
			continue;
		}
	}
	if(!norc) {
		// Process reverse-complement read
		params.setFw(false);
		bt.setQuery(patsrc->bufa());
		bt.setOffs(0, 0, plen, plen, plen, plen);
		bt.backtrack();
	}
}
