/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H
#define SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// substringHelperPizzaChili

template <typename TValue, typename TSpec, typename TPos> struct substringHelperPizzaChili;       	// "projects/library/seqan/index/index_pizzachili_string.h"(520)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec> class Align;       	// "projects/library/seqan/index/index_esa_base.h"(189)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "projects/library/seqan/index/index_esa_base.h"(186)

//____________________________________________________________________________
// BTree

template <unsigned BlockSize > struct BTree;       	// "projects/library/seqan/index/index_esa_find.h"(70)

//____________________________________________________________________________
// BWT

struct BWT;       	// "projects/library/seqan/index/index_base.h"(46)
struct BWT;       	// "projects/library/seqan/index/index_bwt.h"(30)

//____________________________________________________________________________
// BottomUp

template <typename TSpec > struct BottomUp;       	// "projects/library/seqan/index/index_esa_base.h"(125)

//____________________________________________________________________________
// ChildTab

struct ChildTab;       	// "projects/library/seqan/index/index_childtab.h"(30)
struct ChildTab;       	// "projects/library/seqan/index/index_base.h"(45)

//____________________________________________________________________________
// CompareSkewDCStream

template <typename TValue> struct CompareSkewDCStream;       	// "projects/library/seqan/index/pipe_merger7.h"(95)

//____________________________________________________________________________
// DeepShallow

struct DeepShallow;       	// "projects/library/seqan/index/index_shawarma.h"(42)

//____________________________________________________________________________
// DefaultIndexCreator

template <typename TIndex, typename TFibre > struct DefaultIndexCreator;       	// "projects/library/seqan/index/index_base.h"(177)

//____________________________________________________________________________
// DefaultIndexSpec

template <typename TObject > struct DefaultIndexSpec;       	// "projects/library/seqan/index/index_base.h"(63)

//____________________________________________________________________________
// DefaultIndexStringSpec

template <typename TIndex > struct DefaultIndexStringSpec;       	// "projects/library/seqan/index/index_base.h"(78)

//____________________________________________________________________________
// DivSufSort

struct DivSufSort;       	// "projects/library/seqan/index/index_shawarma.h"(41)

//____________________________________________________________________________
// EmptyEdges

struct EmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(102)

//____________________________________________________________________________
// Extender3

struct Extender3;       	// "projects/library/seqan/index/pump_extender3.h"(30)

//____________________________________________________________________________
// Extender7

template <typename TCompression > struct Extender7;       	// "projects/library/seqan/index/pump_extender7.h"(33)

//____________________________________________________________________________
// Extender7Multi

template <typename TPair, typename TCompression > struct Extender7Multi;       	// "projects/library/seqan/index/pump_extender7.h"(228)

//____________________________________________________________________________
// Fibre

template <typename TIndex, typename TSpec > struct Fibre;       	// "projects/library/seqan/index/index_base.h"(141)

//____________________________________________________________________________
// FibreLess

struct FibreLess;       	// "projects/library/seqan/index/index_base.h"(158)

//____________________________________________________________________________
// FibreRecord

struct FibreRecord;       	// "projects/library/seqan/index/index_base.h"(150)

//____________________________________________________________________________
// FixedGappedShape

template <typename TSpec> struct FixedGappedShape;       	// "projects/library/seqan/index/shape_base.h"(32)

//____________________________________________________________________________
// FixedShape

template <unsigned q> struct FixedShape;       	// "projects/library/seqan/index/shape_base.h"(28)

//____________________________________________________________________________
// FunctorGlobalize

template <typename InType, typename TLimitsString, typename Result > struct FunctorGlobalize;       	// "projects/library/seqan/index/index_base.h"(386)

//____________________________________________________________________________
// GetVSTreeIteratorTraits

template <typename TIterator> struct GetVSTreeIteratorTraits;       	// "projects/library/seqan/index/index_esa_base.h"(148)

//____________________________________________________________________________
// HardwiredShape

template <int P00 , int P01 , int P02 , int P03 , int P04 , int P05 , int P06 , int P07 , int P08 , int P09 , int P10 , int P11 , int P12 , int P13 , int P14 , int P15 , int P16 , int P17 , int P18 , int P19 > struct HardwiredShape;       	// "projects/library/seqan/index/shape_gapped.h"(50)

//____________________________________________________________________________
// HideEmptyEdges

struct HideEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(101)

//____________________________________________________________________________
// Index

template <typename TObject, typename TSpec > class Index;       	// "projects/library/seqan/index/index_base.h"(114)

//____________________________________________________________________________
// Index_ESA

template <typename TSpec > struct Index_ESA;       	// "projects/library/seqan/index/index_base.h"(49)

//____________________________________________________________________________
// Index_QGram

template <typename TShapeSpec, typename TSpec > struct Index_QGram;       	// "projects/library/seqan/index/index_qgram.h"(100)

//____________________________________________________________________________
// Index_Wotd

template <typename TSpec > struct Index_Wotd;       	// "projects/library/seqan/index/index_wotd.h"(56)

//____________________________________________________________________________
// InvalidPizzaChiliSpec

struct InvalidPizzaChiliSpec;       	// "projects/library/seqan/index/pizzachili_api.h"(37)

//____________________________________________________________________________
// Kasai

struct Kasai;       	// "projects/library/seqan/index/index_base.h"(41)
struct Kasai;       	// "projects/library/seqan/index/index_lcp.h"(30)

//____________________________________________________________________________
// KasaiOriginal

struct KasaiOriginal;       	// "projects/library/seqan/index/index_base.h"(42)
struct KasaiOriginal;       	// "projects/library/seqan/index/index_lcp.h"(31)

//____________________________________________________________________________
// LarssonSadakane

struct LarssonSadakane;       	// "projects/library/seqan/index/index_sa_lss.h"(336)
struct LarssonSadakane;       	// "projects/library/seqan/index/index_base.h"(35)

//____________________________________________________________________________
// LcpConfig

struct LcpConfig;       	// "projects/library/seqan/index/pump_lcp_core.h"(31)

//____________________________________________________________________________
// LeftCompleteTree

struct LeftCompleteTree;       	// "projects/library/seqan/index/index_esa_find.h"(67)

//____________________________________________________________________________
// MSufSort

struct MSufSort;       	// "projects/library/seqan/index/index_shawarma.h"(40)

//____________________________________________________________________________
// MUMs

struct MUMs;       	// "projects/library/seqan/index/index_esa_base.h"(129)

//____________________________________________________________________________
// ManberMyers

struct ManberMyers;       	// "projects/library/seqan/index/index_sa_mm.h"(27)
struct ManberMyers;       	// "projects/library/seqan/index/index_base.h"(36)

//____________________________________________________________________________
// MaxRepeat

template <typename TSTree> struct MaxRepeat;       	// "projects/library/seqan/index/index_esa_algs.h"(602)

//____________________________________________________________________________
// MaxRepeatOccurrences

struct MaxRepeatOccurrences;       	// "projects/library/seqan/index/index_esa_base.h"(132)

//____________________________________________________________________________
// Merger3

struct Merger3;       	// "projects/library/seqan/index/pipe_merger3.h"(30)

//____________________________________________________________________________
// Merger7

struct Merger7;       	// "projects/library/seqan/index/pipe_merger7.h"(178)

//____________________________________________________________________________
// Merger7Multi

template <typename TLimitsString> struct Merger7Multi;       	// "projects/library/seqan/index/pipe_merger7.h"(187)

//____________________________________________________________________________
// MultiMEM

template <typename TSTree> struct MultiMEM;       	// "projects/library/seqan/index/index_esa_algs_multi.h"(385)

//____________________________________________________________________________
// MultiMEMOccurences

struct MultiMEMOccurences;       	// "projects/library/seqan/index/index_esa_base.h"(134)

//____________________________________________________________________________
// ParentLinks

template <typename TSpec > struct ParentLinks;       	// "projects/library/seqan/index/index_esa_base.h"(121)

//____________________________________________________________________________
// PizzaChili

template <typename TSpec> struct PizzaChili;       	// "projects/library/seqan/index/index_pizzachili_string.h"(47)

//____________________________________________________________________________
// PizzaChiliCodeProvider

template <typename TSpec> struct PizzaChiliCodeProvider;       	// "projects/library/seqan/index/pizzachili_api.h"(40)

//____________________________________________________________________________
// Postorder

struct Postorder;       	// "projects/library/seqan/index/index_esa_base.h"(96)

//____________________________________________________________________________
// PostorderEmptyEdges

struct PostorderEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(98)

//____________________________________________________________________________
// Preorder

struct Preorder;       	// "projects/library/seqan/index/index_esa_base.h"(95)

//____________________________________________________________________________
// PreorderEmptyEdges

struct PreorderEmptyEdges;       	// "projects/library/seqan/index/index_esa_base.h"(97)

//____________________________________________________________________________
// QGram_Alg

struct QGram_Alg;       	// "projects/library/seqan/index/index_base.h"(38)

//____________________________________________________________________________
// QSufSort

struct QSufSort;       	// "projects/library/seqan/index/index_shawarma.h"(43)

//____________________________________________________________________________
// Repeat

template <typename TPos, typename TPeriod> struct Repeat;       	// "projects/library/seqan/index/repeat_base.h"(28)

//____________________________________________________________________________
// RepeatFinderParams

template <typename TSize> struct RepeatFinderParams;       	// "projects/library/seqan/index/repeat_base.h"(47)

//____________________________________________________________________________
// SAQSort

struct SAQSort;       	// "projects/library/seqan/index/index_base.h"(37)
struct SAQSort;       	// "projects/library/seqan/index/index_sa_qsort.h"(27)

//____________________________________________________________________________
// SAValue

template <typename TObject> struct SAValue;       	// "projects/library/seqan/index/index_base.h"(288)

//____________________________________________________________________________
// SearchTreeIterator

template <typename TString, typename TSpec > class SearchTreeIterator;       	// "projects/library/seqan/index/index_esa_find.h"(73)

//____________________________________________________________________________
// Shape

template <typename TValue , typename TSpec > class Shape;       	// "projects/library/seqan/index/shape_base.h"(54)

//____________________________________________________________________________
// Shawarma

template <typename TSpec> struct Shawarma;       	// "projects/library/seqan/index/index_shawarma.h"(38)

//____________________________________________________________________________
// Skew3

struct Skew3;       	// "projects/library/seqan/index/index_base.h"(33)
struct Skew3;       	// "projects/library/seqan/index/index_skew3.h"(30)

//____________________________________________________________________________
// Skew7

struct Skew7;       	// "projects/library/seqan/index/index_base.h"(34)
struct Skew7;       	// "projects/library/seqan/index/index_skew7.h"(30)

//____________________________________________________________________________
// SkewDCStream

template <typename TValue> struct SkewDCStream;       	// "projects/library/seqan/index/pipe_merger7.h"(71)

//____________________________________________________________________________
// SortedList

struct SortedList;       	// "projects/library/seqan/index/index_esa_find.h"(66)

//____________________________________________________________________________
// SuperMaxRepeats

struct SuperMaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(127)

//____________________________________________________________________________
// SuperMaxRepeatsFast

struct SuperMaxRepeatsFast;       	// "projects/library/seqan/index/index_esa_base.h"(128)

//____________________________________________________________________________
// TRepeatFinder

struct TRepeatFinder;       	// "projects/library/seqan/index/repeat_base.h"(53)

//____________________________________________________________________________
// TopDown

template <typename TSpec > struct TopDown;       	// "projects/library/seqan/index/index_esa_base.h"(117)

//____________________________________________________________________________
// VSTree

template <typename TSpec > struct VSTree;       	// "projects/library/seqan/index/index_esa_base.h"(113)

//____________________________________________________________________________
// VSTreeIteratorTraits

template <typename TDFSOrder , typename THideEmptyEdges > struct VSTreeIteratorTraits;       	// "projects/library/seqan/index/index_esa_base.h"(32)

//____________________________________________________________________________
// VertexESA

template <typename TSize> struct VertexESA;       	// "projects/library/seqan/index/index_esa_base.h"(153)

//____________________________________________________________________________
// WotdDFI

template <typename TPredHull , typename TPred > struct WotdDFI;       	// "projects/library/seqan/index/index_dfi.h"(74)

//____________________________________________________________________________
// WotdOriginal_

struct WotdOriginal_;       	// "projects/library/seqan/index/index_wotd.h"(52)

//____________________________________________________________________________
// _AllocHelper

template <typename TValue, typename TSpec> struct _AllocHelper;       	// "projects/library/seqan/index/index_pizzachili_string.h"(283)

//____________________________________________________________________________
// _Context_LSS

template <typename TValue> struct _Context_LSS;       	// "projects/library/seqan/index/index_sa_lss.h"(40)

//____________________________________________________________________________
// _DFIEntry

struct _DFIEntry;       	// "projects/library/seqan/index/index_dfi.h"(32)

//____________________________________________________________________________
// _DFIPredDefault

template <bool RESULT> struct _DFIPredDefault;       	// "projects/library/seqan/index/index_dfi.h"(44)

//____________________________________________________________________________
// _Fibre_BWT

struct _Fibre_BWT;       	// "projects/library/seqan/index/index_base.h"(245)

//____________________________________________________________________________
// _Fibre_ChildTab

struct _Fibre_ChildTab;       	// "projects/library/seqan/index/index_base.h"(244)

//____________________________________________________________________________
// _Fibre_Counts

struct _Fibre_Counts;       	// "projects/library/seqan/index/index_qgram.h"(64)

//____________________________________________________________________________
// _Fibre_CountsDir

struct _Fibre_CountsDir;       	// "projects/library/seqan/index/index_qgram.h"(65)

//____________________________________________________________________________
// _Fibre_Dir

struct _Fibre_Dir;       	// "projects/library/seqan/index/index_qgram.h"(61)

//____________________________________________________________________________
// _Fibre_LCP

struct _Fibre_LCP;       	// "projects/library/seqan/index/index_base.h"(242)

//____________________________________________________________________________
// _Fibre_LCPE

struct _Fibre_LCPE;       	// "projects/library/seqan/index/index_base.h"(243)

//____________________________________________________________________________
// _Fibre_PizzaChili_Compressed

struct _Fibre_PizzaChili_Compressed;       	// "projects/library/seqan/index/index_pizzachili.h"(41)

//____________________________________________________________________________
// _Fibre_RawSA

struct _Fibre_RawSA;       	// "projects/library/seqan/index/index_base.h"(240)

//____________________________________________________________________________
// _Fibre_RawText

struct _Fibre_RawText;       	// "projects/library/seqan/index/index_base.h"(238)

//____________________________________________________________________________
// _Fibre_SA

struct _Fibre_SA;       	// "projects/library/seqan/index/index_base.h"(239)

//____________________________________________________________________________
// _Fibre_SADir

struct _Fibre_SADir;       	// "projects/library/seqan/index/index_qgram.h"(62)

//____________________________________________________________________________
// _Fibre_SAE

struct _Fibre_SAE;       	// "projects/library/seqan/index/index_base.h"(241)

//____________________________________________________________________________
// _Fibre_Shape

struct _Fibre_Shape;       	// "projects/library/seqan/index/index_qgram.h"(63)

//____________________________________________________________________________
// _Fibre_Text

struct _Fibre_Text;       	// "projects/library/seqan/index/index_base.h"(237)

//____________________________________________________________________________
// _Finder_LCPE

struct _Finder_LCPE;       	// "projects/library/seqan/index/index_esa_find.h"(49)

//____________________________________________________________________________
// _Finder_MLR

struct _Finder_MLR;       	// "projects/library/seqan/index/index_esa_find.h"(48)

//____________________________________________________________________________
// _Finder_QGramLookup

struct _Finder_QGramLookup;       	// "projects/library/seqan/index/index_qgram_find.h"(30)

//____________________________________________________________________________
// _FractionCompound

template <typename TValue, typename TSize> struct _FractionCompound;       	// "projects/library/seqan/index/index_esa_algs.h"(250)

//____________________________________________________________________________
// _FractionHeader

template <typename TSize> struct _FractionHeader;       	// "projects/library/seqan/index/index_esa_algs.h"(239)

//____________________________________________________________________________
// _FractionMultiCompound

template <typename TValue, typename TSize> struct _FractionMultiCompound;       	// "projects/library/seqan/index/index_esa_algs_multi.h"(132)

//____________________________________________________________________________
// _HistoryStackEntry

template <typename TVSTreeIter > struct _HistoryStackEntry;       	// "projects/library/seqan/index/index_esa_stree.h"(125)

//____________________________________________________________________________
// _HistoryStackWotdModified

template <typename TSize> struct _HistoryStackWotdModified;       	// "projects/library/seqan/index/index_wotd.h"(209)

//____________________________________________________________________________
// _HistoryStackWotdOriginal

template <typename TSize> struct _HistoryStackWotdOriginal;       	// "projects/library/seqan/index/index_wotd.h"(202)

//____________________________________________________________________________
// _MaxRepeats

template <typename TSpec > struct _MaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(106)

//____________________________________________________________________________
// _MultiMEMs

struct _MultiMEMs;       	// "projects/library/seqan/index/index_esa_base.h"(107)

//____________________________________________________________________________
// _PizzaChiliFinder

struct _PizzaChiliFinder;       	// "projects/library/seqan/index/index_pizzachili_find.h"(26)

//____________________________________________________________________________
// _PizzaChili_AF

struct _PizzaChili_AF;       	// "projects/library/seqan/index/pizzachili_api.h"(67)

//____________________________________________________________________________
// _PizzaChili_CCSA

struct _PizzaChili_CCSA;       	// "projects/library/seqan/index/pizzachili_api.h"(70)

//____________________________________________________________________________
// _PizzaChili_FM

struct _PizzaChili_FM;       	// "projects/library/seqan/index/pizzachili_api.h"(73)

//____________________________________________________________________________
// _PizzaChili_LZ

struct _PizzaChili_LZ;       	// "projects/library/seqan/index/pizzachili_api.h"(76)

//____________________________________________________________________________
// _PizzaChili_RLFM

struct _PizzaChili_RLFM;       	// "projects/library/seqan/index/pizzachili_api.h"(82)

//____________________________________________________________________________
// _PizzaChili_RSA

struct _PizzaChili_RSA;       	// "projects/library/seqan/index/pizzachili_api.h"(79)

//____________________________________________________________________________
// _PizzaChili_SA

struct _PizzaChili_SA;       	// "projects/library/seqan/index/pizzachili_api.h"(85)

//____________________________________________________________________________
// _PizzaChili_SADA

struct _PizzaChili_SADA;       	// "projects/library/seqan/index/pizzachili_api.h"(88)

//____________________________________________________________________________
// _PizzaChili_SSA

struct _PizzaChili_SSA;       	// "projects/library/seqan/index/pizzachili_api.h"(91)

//____________________________________________________________________________
// _PizzaChili_Test

struct _PizzaChili_Test;       	// "projects/library/seqan/index/pizzachili_api.h"(94)

//____________________________________________________________________________
// _Postorder

struct _Postorder;       	// "projects/library/seqan/index/index_esa_base.h"(29)

//____________________________________________________________________________
// _Preorder

struct _Preorder;       	// "projects/library/seqan/index/index_esa_base.h"(28)

//____________________________________________________________________________
// _QGramLess

template <typename TSAValue, typename TText > struct _QGramLess;       	// "projects/library/seqan/index/index_qgram.h"(347)

//____________________________________________________________________________
// _QGramLessNoCheck

template <typename TSAValue, typename TText > struct _QGramLessNoCheck;       	// "projects/library/seqan/index/index_qgram.h"(506)

//____________________________________________________________________________
// _QGramLessNoCheckOffset

template <typename TSAValue, typename TText > struct _QGramLessNoCheckOffset;       	// "projects/library/seqan/index/index_qgram.h"(588)

//____________________________________________________________________________
// _QGramLessOffset

template <typename TSAValue, typename TText > struct _QGramLessOffset;       	// "projects/library/seqan/index/index_qgram.h"(442)

//____________________________________________________________________________
// _RepeatLess

template <typename TPos> struct _RepeatLess;       	// "projects/library/seqan/index/repeat_base.h"(82)

//____________________________________________________________________________
// _SAValueLess

template <typename TOccValue> struct _SAValueLess;       	// "projects/library/seqan/index/index_shims.h"(449)

//____________________________________________________________________________
// _SkewNIndx

template <int I, typename T > struct _SkewNIndx;       	// "projects/library/seqan/index/pipe_merger7.h"(34)

//____________________________________________________________________________
// _SkewShift

template <int I, typename T > struct _SkewShift;       	// "projects/library/seqan/index/pipe_merger7.h"(31)

//____________________________________________________________________________
// _SuffixLess

template <typename TSAValue, typename TText > struct _SuffixLess;       	// "projects/library/seqan/index/index_sa_qsort.h"(33)

//____________________________________________________________________________
// _SuffixLessOffset

template <typename TSAValue, typename TText > struct _SuffixLessOffset;       	// "projects/library/seqan/index/index_sa_qsort.h"(71)

//____________________________________________________________________________
// _VertexWotdModified

template <typename TSize> struct _VertexWotdModified;       	// "projects/library/seqan/index/index_wotd.h"(163)

//____________________________________________________________________________
// _VertexWotdOriginal

template <typename TSize> struct _VertexWotdOriginal;       	// "projects/library/seqan/index/index_wotd.h"(148)

//____________________________________________________________________________
// _qgram_comp

template <typename InType, typename Result > struct _qgram_comp;       	// "projects/library/seqan/index/index_qgram.h"(1227)

//____________________________________________________________________________
// _qgram_hash

template <typename TValue, typename TResult > struct _qgram_hash;       	// "projects/library/seqan/index/index_qgram.h"(1262)

//____________________________________________________________________________
// filter_globalizer

template <typename InType, typename TLimitsString, typename Result > struct filter_globalizer;       	// "projects/library/seqan/index/index_bwt.h"(130)

//____________________________________________________________________________
// map_inverse

template <typename InType, typename Result > struct map_inverse;       	// "projects/library/seqan/index/index_lcp.h"(45)

//____________________________________________________________________________
// map_inverse_multi

template <typename InType, typename TLimitsString, typename Result > struct map_inverse_multi;       	// "projects/library/seqan/index/index_lcp.h"(148)

//____________________________________________________________________________
// skew3_extend_comp

template <typename InType, typename Result > struct skew3_extend_comp;       	// "projects/library/seqan/index/index_skew3.h"(107)

//____________________________________________________________________________
// skew3_ncomp

template <typename InType, typename Result > struct skew3_ncomp;       	// "projects/library/seqan/index/index_skew3.h"(49)

//____________________________________________________________________________
// skew3_nmap_extended

template <typename InType, typename Result > struct skew3_nmap_extended;       	// "projects/library/seqan/index/index_skew3.h"(101)

//____________________________________________________________________________
// skew3_nmap_linear

template <typename InType, typename Result > struct skew3_nmap_linear;       	// "projects/library/seqan/index/index_skew3.h"(72)

//____________________________________________________________________________
// skew3_nmap_sliced

template <typename InType, typename Result > struct skew3_nmap_sliced;       	// "projects/library/seqan/index/index_skew3.h"(80)

//____________________________________________________________________________
// skew3_unslicer_func

template <typename InType, typename Result > struct skew3_unslicer_func;       	// "projects/library/seqan/index/index_skew3.h"(89)

//____________________________________________________________________________
// skew7_extend_comp

template <typename InType, const int EXT_LENGTH, typename Result > struct skew7_extend_comp;       	// "projects/library/seqan/index/index_skew7.h"(137)

//____________________________________________________________________________
// skew7_global_sliced_multi

template <typename InType, typename TLimitsString, typename TResultSize , typename Result > struct skew7_global_sliced_multi;       	// "projects/library/seqan/index/index_skew7_multi.h"(109)

//____________________________________________________________________________
// skew7_ncomp

template <typename InType, typename Result > struct skew7_ncomp;       	// "projects/library/seqan/index/index_skew7.h"(49)

//____________________________________________________________________________
// skew7_ncomp_multi

template <typename InType, typename Result > struct skew7_ncomp_multi;       	// "projects/library/seqan/index/index_skew7_multi.h"(42)

//____________________________________________________________________________
// skew7_nmap_extended

template <typename InType, typename Result > struct skew7_nmap_extended;       	// "projects/library/seqan/index/index_skew7.h"(131)

//____________________________________________________________________________
// skew7_nmap_linear

template <typename InType, typename Result > struct skew7_nmap_linear;       	// "projects/library/seqan/index/index_skew7.h"(91)

//____________________________________________________________________________
// skew7_nmap_sliced

template <typename InType, typename Result > struct skew7_nmap_sliced;       	// "projects/library/seqan/index/index_skew7.h"(99)

//____________________________________________________________________________
// skew7_unslicer_func

template <typename InType, typename Result > struct skew7_unslicer_func;       	// "projects/library/seqan/index/index_skew7.h"(115)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// error_t

typedef int error_t;       	// "projects/library/seqan/index/pizzachili_api.h"(34)

//____________________________________________________________________________
// index_t

typedef void* index_t;       	// "projects/library/seqan/index/pizzachili_api.h"(33)

//____________________________________________________________________________
// uchar_t

typedef unsigned char uchar_t;       	// "projects/library/seqan/index/pizzachili_api.h"(31)

//____________________________________________________________________________
// ulong_t

typedef unsigned long ulong_t;       	// "projects/library/seqan/index/pizzachili_api.h"(32)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// ESA_BWT

typedef Fibre_BWT ESA_BWT;       	// "projects/library/seqan/index/index_esa_base.h"(239)

//____________________________________________________________________________
// ESA_ChildTab

typedef Fibre_ChildTab ESA_ChildTab;       	// "projects/library/seqan/index/index_esa_base.h"(238)

//____________________________________________________________________________
// ESA_FIND_LCPE

typedef Tag<_Finder_LCPE> const ESA_FIND_LCPE;       	// "projects/library/seqan/index/index_esa_find.h"(52)

//____________________________________________________________________________
// ESA_FIND_MLR

typedef Tag<_Finder_MLR> const ESA_FIND_MLR;       	// "projects/library/seqan/index/index_esa_find.h"(51)

//____________________________________________________________________________
// ESA_LCP

typedef Fibre_LCP ESA_LCP;       	// "projects/library/seqan/index/index_esa_base.h"(236)

//____________________________________________________________________________
// ESA_LCPE

typedef Fibre_LCPE ESA_LCPE;       	// "projects/library/seqan/index/index_esa_base.h"(237)

//____________________________________________________________________________
// ESA_RawSA

typedef Fibre_RawSA ESA_RawSA;       	// "projects/library/seqan/index/index_esa_base.h"(234)

//____________________________________________________________________________
// ESA_RawText

typedef Fibre_RawText ESA_RawText;       	// "projects/library/seqan/index/index_esa_base.h"(232)

//____________________________________________________________________________
// ESA_SA

typedef Fibre_SA ESA_SA;       	// "projects/library/seqan/index/index_esa_base.h"(233)

//____________________________________________________________________________
// ESA_SAE

typedef Fibre_SAE ESA_SAE;       	// "projects/library/seqan/index/index_esa_base.h"(235)

//____________________________________________________________________________
// ESA_Text

typedef Fibre_Text ESA_Text;       	// "projects/library/seqan/index/index_esa_base.h"(231)

//____________________________________________________________________________
// Fibre_BWT

typedef Tag<_Fibre_BWT> const Fibre_BWT;       	// "projects/library/seqan/index/index_base.h"(255)

//____________________________________________________________________________
// Fibre_ChildTab

typedef Tag<_Fibre_ChildTab> const Fibre_ChildTab;       	// "projects/library/seqan/index/index_base.h"(254)

//____________________________________________________________________________
// Fibre_Counts

typedef Tag<_Fibre_Counts> const Fibre_Counts;       	// "projects/library/seqan/index/index_qgram.h"(70)

//____________________________________________________________________________
// Fibre_CountsDir

typedef Tag<_Fibre_CountsDir> const Fibre_CountsDir;       	// "projects/library/seqan/index/index_qgram.h"(71)

//____________________________________________________________________________
// Fibre_Dir

typedef Tag<_Fibre_Dir> const Fibre_Dir;       	// "projects/library/seqan/index/index_qgram.h"(67)

//____________________________________________________________________________
// Fibre_LCP

typedef Tag<_Fibre_LCP> const Fibre_LCP;       	// "projects/library/seqan/index/index_base.h"(252)

//____________________________________________________________________________
// Fibre_LCPE

typedef Tag<_Fibre_LCPE> const Fibre_LCPE;       	// "projects/library/seqan/index/index_base.h"(253)

//____________________________________________________________________________
// Fibre_PizzaChili_Compressed

typedef Tag<_Fibre_PizzaChili_Compressed> const Fibre_PizzaChili_Compressed;       	// "projects/library/seqan/index/index_pizzachili.h"(44)

//____________________________________________________________________________
// Fibre_PizzaChili_Text

typedef Tag<_Fibre_Text> const Fibre_PizzaChili_Text;       	// "projects/library/seqan/index/index_pizzachili.h"(43)

//____________________________________________________________________________
// Fibre_RawSA

typedef Tag<_Fibre_RawSA> const Fibre_RawSA;       	// "projects/library/seqan/index/index_base.h"(250)

//____________________________________________________________________________
// Fibre_RawText

typedef Tag<_Fibre_RawText> const Fibre_RawText;       	// "projects/library/seqan/index/index_base.h"(248)

//____________________________________________________________________________
// Fibre_SA

typedef Tag<_Fibre_SA> const Fibre_SA;       	// "projects/library/seqan/index/index_base.h"(249)

//____________________________________________________________________________
// Fibre_SADir

typedef Tag<_Fibre_SADir> const Fibre_SADir;       	// "projects/library/seqan/index/index_qgram.h"(68)

//____________________________________________________________________________
// Fibre_SAE

typedef Tag<_Fibre_SAE> const Fibre_SAE;       	// "projects/library/seqan/index/index_base.h"(251)

//____________________________________________________________________________
// Fibre_Shape

typedef Tag<_Fibre_Shape> const Fibre_Shape;       	// "projects/library/seqan/index/index_qgram.h"(69)

//____________________________________________________________________________
// Fibre_Text

typedef Tag<_Fibre_Text> const Fibre_Text;       	// "projects/library/seqan/index/index_base.h"(247)

//____________________________________________________________________________
// GappedShape

typedef FixedGappedShape<Default> GappedShape;       	// "projects/library/seqan/index/shape_base.h"(33)

//____________________________________________________________________________
// MaxRepeats

typedef _MaxRepeats<void> MaxRepeats;       	// "projects/library/seqan/index/index_esa_base.h"(131)

//____________________________________________________________________________
// MultiMEMs

typedef _MaxRepeats<_MultiMEMs> MultiMEMs;       	// "projects/library/seqan/index/index_esa_base.h"(133)

//____________________________________________________________________________
// PizzaChiliFinder

typedef Tag<_PizzaChiliFinder> const PizzaChiliFinder;       	// "projects/library/seqan/index/index_pizzachili_find.h"(36)

//____________________________________________________________________________
// PizzaChili_AF

typedef Tag<_PizzaChili_AF> const PizzaChili_AF;       	// "projects/library/seqan/index/pizzachili_api.h"(68)

//____________________________________________________________________________
// PizzaChili_CCSA

typedef Tag<_PizzaChili_CCSA> const PizzaChili_CCSA;       	// "projects/library/seqan/index/pizzachili_api.h"(71)

//____________________________________________________________________________
// PizzaChili_Compressed

typedef Fibre_PizzaChili_Compressed PizzaChili_Compressed;       	// "projects/library/seqan/index/index_pizzachili.h"(47)

//____________________________________________________________________________
// PizzaChili_FM

typedef Tag<_PizzaChili_FM> const PizzaChili_FM;       	// "projects/library/seqan/index/pizzachili_api.h"(74)

//____________________________________________________________________________
// PizzaChili_LZ

typedef Tag<_PizzaChili_LZ> const PizzaChili_LZ;       	// "projects/library/seqan/index/pizzachili_api.h"(77)

//____________________________________________________________________________
// PizzaChili_RLFM

typedef Tag<_PizzaChili_RLFM> const PizzaChili_RLFM;       	// "projects/library/seqan/index/pizzachili_api.h"(83)

//____________________________________________________________________________
// PizzaChili_RSA

typedef Tag<_PizzaChili_RSA> const PizzaChili_RSA;       	// "projects/library/seqan/index/pizzachili_api.h"(80)

//____________________________________________________________________________
// PizzaChili_SA

typedef Tag<_PizzaChili_SA> const PizzaChili_SA;       	// "projects/library/seqan/index/pizzachili_api.h"(86)

//____________________________________________________________________________
// PizzaChili_SADA

typedef Tag<_PizzaChili_SADA> const PizzaChili_SADA;       	// "projects/library/seqan/index/pizzachili_api.h"(89)

//____________________________________________________________________________
// PizzaChili_SSA

typedef Tag<_PizzaChili_SSA> const PizzaChili_SSA;       	// "projects/library/seqan/index/pizzachili_api.h"(92)

//____________________________________________________________________________
// PizzaChili_Test

typedef Tag<_PizzaChili_Test> const PizzaChili_Test;       	// "projects/library/seqan/index/pizzachili_api.h"(95)

//____________________________________________________________________________
// PizzaChili_Text

typedef Fibre_PizzaChili_Text PizzaChili_Text;       	// "projects/library/seqan/index/index_pizzachili.h"(46)

//____________________________________________________________________________
// QGram_Counts

typedef Fibre_Counts QGram_Counts;       	// "projects/library/seqan/index/index_qgram.h"(82)

//____________________________________________________________________________
// QGram_CountsDir

typedef Fibre_CountsDir QGram_CountsDir;       	// "projects/library/seqan/index/index_qgram.h"(83)

//____________________________________________________________________________
// QGram_Dir

typedef Fibre_Dir QGram_Dir;       	// "projects/library/seqan/index/index_qgram.h"(79)

//____________________________________________________________________________
// QGram_FIND_Lookup

typedef Tag<_Finder_QGramLookup> const QGram_FIND_Lookup;       	// "projects/library/seqan/index/index_qgram_find.h"(38)

//____________________________________________________________________________
// QGram_RawSA

typedef Fibre_RawSA QGram_RawSA;       	// "projects/library/seqan/index/index_qgram.h"(78)

//____________________________________________________________________________
// QGram_RawText

typedef Fibre_RawText QGram_RawText;       	// "projects/library/seqan/index/index_qgram.h"(76)

//____________________________________________________________________________
// QGram_SA

typedef Fibre_SA QGram_SA;       	// "projects/library/seqan/index/index_qgram.h"(77)

//____________________________________________________________________________
// QGram_SADir

typedef Fibre_SADir QGram_SADir;       	// "projects/library/seqan/index/index_qgram.h"(80)

//____________________________________________________________________________
// QGram_Shape

typedef Fibre_Shape QGram_Shape;       	// "projects/library/seqan/index/index_qgram.h"(81)

//____________________________________________________________________________
// QGram_Text

typedef Fibre_Text QGram_Text;       	// "projects/library/seqan/index/index_qgram.h"(75)

//____________________________________________________________________________
// SimpleShape

typedef FixedShape<0> SimpleShape;       	// "projects/library/seqan/index/shape_base.h"(29)

//____________________________________________________________________________
// WotdOriginal

typedef Tag<WotdOriginal_> const WotdOriginal;       	// "projects/library/seqan/index/index_wotd.h"(53)

//____________________________________________________________________________
// Wotd_Dir

typedef Fibre_Dir Wotd_Dir;       	// "projects/library/seqan/index/index_wotd.h"(35)

//____________________________________________________________________________
// Wotd_RawSA

typedef Fibre_RawSA Wotd_RawSA;       	// "projects/library/seqan/index/index_wotd.h"(34)

//____________________________________________________________________________
// Wotd_RawText

typedef Fibre_RawText Wotd_RawText;       	// "projects/library/seqan/index/index_wotd.h"(32)

//____________________________________________________________________________
// Wotd_SA

typedef Fibre_SA Wotd_SA;       	// "projects/library/seqan/index/index_wotd.h"(33)

//____________________________________________________________________________
// Wotd_Text

typedef Fibre_Text Wotd_Text;       	// "projects/library/seqan/index/index_wotd.h"(31)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// clearIndex

template <typename TText, typename TSpec> inline void clearIndex(Index<TText, PizzaChili<TSpec> >& me);       	// "projects/library/seqan/index/index_pizzachili.h"(132)

//____________________________________________________________________________
// createPizzaChiliIndex

template <typename TText, typename TSpec> inline bool createPizzaChiliIndex( Index<TText, PizzaChili<TSpec> >& me, uchar_t* textstart, ulong_t textlength );       	// "projects/library/seqan/index/index_pizzachili.h"(256)

//____________________________________________________________________________
// getOptionsString

template <typename TText, typename TSpec> inline char const* getOptionsString(Index<TText, PizzaChili<TSpec> >& );       	// "projects/library/seqan/index/index_pizzachili.h"(162)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChili_SA> >& );       	// "projects/library/seqan/index/index_pizzachili.h"(169)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChili_FM> >& );       	// "projects/library/seqan/index/index_pizzachili.h"(176)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChili_RSA> >& );       	// "projects/library/seqan/index/index_pizzachili.h"(183)

//____________________________________________________________________________
// getPizzaChiliString

template <typename TPattern> inline uchar_t* getPizzaChiliString(TPattern const& pattern);       	// "projects/library/seqan/index/index_pizzachili_find.h"(92)
inline uchar_t* getPizzaChiliString(char const* pattern);       	// "projects/library/seqan/index/index_pizzachili_find.h"(110)

//____________________________________________________________________________
// queryText

template <typename TValue, typename TSpec> inline void queryText(String<TValue, PizzaChili<TSpec> > const& me);       	// "projects/library/seqan/index/index_pizzachili_string.h"(419)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __cp_

template <typename Dest, typename Ofs, typename Src> static finline Src const __cp_(Dest &dst, Ofs const ofs, Src const src);       	// "projects/library/seqan/index/pump_extender7.h"(67)

//____________________________________________________________________________
// _adjustRightBorder

template <typename TText, typename TSpec > inline void _adjustRightBorder( Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &);       	// "projects/library/seqan/index/index_wotd.h"(493)
template <typename TText, typename TIndexSpec, typename TSpec > inline void _adjustRightBorder( Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_wotd.h"(499)

//____________________________________________________________________________
// _bucketLCP

template <typename TSA, typename TText > typename Size<TText>::Type _bucketLCP(TSA const &sa, TText const &text);       	// "projects/library/seqan/index/index_wotd.h"(1249)
template <typename TSA, typename TText, typename TSize > typename Size<TText>::Type _bucketLCP(TSA const &sa, TText const &text, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(1283)
template <typename TSA, typename TText, typename TSpec, typename TSize > typename Size<TText>::Type _bucketLCP(TSA const &sa, StringSet<TText, TSpec> const &stringSet, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(1315)

//____________________________________________________________________________
// _createBWTableWrapper

template <typename TBWT, typename TText, typename TSA, typename _TTextRandom > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, _TTextRandom const);       	// "projects/library/seqan/index/index_shims.h"(424)
template <typename TBWT, typename TText, typename TSA > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, True const);       	// "projects/library/seqan/index/index_shims.h"(432)

//____________________________________________________________________________
// _dataHost

template <typename TText, typename TSpec> inline Holder<TText> & _dataHost(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(464)
template <typename TText, typename TSpec> inline Holder<TText> const & _dataHost(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(468)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue, typename TSpec> inline void _deallocateStorage( String<TValue, PizzaChili<TSpec> >& , TValue* begin, typename Size<String<TValue, PizzaChili<TSpec> > >::Type );       	// "projects/library/seqan/index/index_pizzachili_string.h"(370)

//____________________________________________________________________________
// _dfsClear

template <typename TIndex, class TSpec > inline void _dfsClear(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1393)

//____________________________________________________________________________
// _dfsLCP

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type & _dfsLCP(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1860)
template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type _dfsLCP(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1866)

//____________________________________________________________________________
// _dfsOnLeaf

template <typename TIndex, typename TSpec > inline void _dfsOnLeaf(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(274)
template <typename TSTree, typename TSpec > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(496)
template <typename TSTree > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<MultiMEMs> > > &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(338)

//____________________________________________________________________________
// _dfsOnPop

template <typename TIndex, typename TSpec, typename TSize > inline void _dfsOnPop(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TSize const);       	// "projects/library/seqan/index/index_esa_stree.h"(262)

//____________________________________________________________________________
// _dfsOnPush

template <typename TIndex, typename TSpec, typename TElement > inline void _dfsOnPush(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TElement const &e);       	// "projects/library/seqan/index/index_esa_stree.h"(269)
template <typename TSTree, typename TElement, typename TSpec > inline void _dfsOnPush(Iter<TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it, TElement const &e);       	// "projects/library/seqan/index/index_esa_algs.h"(482)

//____________________________________________________________________________
// _dfsRange

template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1847)
template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> const & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1854)

//____________________________________________________________________________
// _dfsReversedOrder

template <typename TIndex, typename TSpec > inline bool _dfsReversedOrder(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(256)

//____________________________________________________________________________
// _dump

template <typename TText, typename TPredHull, typename TPred> inline void _dump(Index<TText, Index_Wotd< WotdDFI<TPredHull, TPred> > > &index);       	// "projects/library/seqan/index/index_dfi.h"(470)
template <typename TText, typename TSpec> inline void _dump(Index<TText, Index_Wotd<TSpec> > &index);       	// "projects/library/seqan/index/index_wotd.h"(1580)
template <typename TText, typename TSpec> inline void _dump(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_stree.h"(238)

//____________________________________________________________________________
// _dumpFreq

template <typename TText, typename TPredHull, typename TPred> inline void _dumpFreq(Index<TText, Index_Wotd< WotdDFI<TPredHull, TPred> > > &index);       	// "projects/library/seqan/index/index_dfi.h"(497)

//____________________________________________________________________________
// _dumpHistoryStack

template <typename TIndex, typename TSpec > inline void _dumpHistoryStack(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(229)

//____________________________________________________________________________
// _equalRangeLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1362)
template <typename TText, typename TSA, typename TLCP, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLCPE( TText &text, TSA &sa, TLCP &lcp, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1514)

//____________________________________________________________________________
// _equalRangeSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(632)

//____________________________________________________________________________
// _findFirstIndex

template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern> inline void _findFirstIndex( Finder<Index<TText, PizzaChili<TSpec> >, TSpecFinder>& finder, TPattern const& pattern, PizzaChiliFinder const );       	// "projects/library/seqan/index/index_pizzachili_find.h"(123)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, QGram_FIND_Lookup const);       	// "projects/library/seqan/index/index_qgram_find.h"(57)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, ESA_FIND_MLR const);       	// "projects/library/seqan/index/index_esa_find.h"(1742)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, ESA_FIND_LCPE const);       	// "projects/library/seqan/index/index_esa_find.h"(1754)

//____________________________________________________________________________
// _fractionMerge

template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, _FractionCompound<TValue, TSize> &parent, _FractionCompound<TValue, TSize> &child);       	// "projects/library/seqan/index/index_esa_algs.h"(451)
template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, _FractionMultiCompound<TValue, TSize> &parent, _FractionMultiCompound<TValue, TSize> &child);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(317)

//____________________________________________________________________________
// _fullDir2Length

template <typename TIndex> inline int _fullDir2Length(TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(330)

//____________________________________________________________________________
// _fullDirLength

template <typename TIndex> inline int _fullDirLength(TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(322)

//____________________________________________________________________________
// _getDown

template <typename TSize, typename TIndex > inline TSize _getDown(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1836)

//____________________________________________________________________________
// _getNextl

template <typename TSize, typename TIndex > inline TSize _getNextl(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1821)

//____________________________________________________________________________
// _getNodeByChar

template <typename TText, class TSpec, typename TValue > inline bool _getNodeByChar( Iter< Index<TText, Index_ESA<TSpec> >, VSTree<TSpec> > const &it, TValue c, typename VertexDescriptor< Index<TText, Index_ESA<TSpec> > >::Type &childDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(787)

//____________________________________________________________________________
// _getNodeLP

template <typename TText, typename TSpec, typename TPos> inline TPos _getNodeLP( Index<TText, Index_Wotd<TSpec> > const &index, TPos pos);       	// "projects/library/seqan/index/index_wotd.h"(1366)

//____________________________________________________________________________
// _getUp

template <typename TSize, typename TIndex > inline TSize _getUp(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1827)

//____________________________________________________________________________
// _goDown

template <typename TText, typename TSpec, typename TDFSOrder, typename THideEmptyEdges > inline bool _goDown( Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_wotd.h"(524)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDFSOrder, typename THideEmptyEdges > inline bool _goDown( Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_wotd.h"(560)
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder > inline bool _goDown( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, False> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1035)
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder > inline bool _goDown( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, True> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1055)

//____________________________________________________________________________
// _goDownChar

template <typename TText, class TSpec, typename TValue > inline bool _goDownChar( Iter<Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "projects/library/seqan/index/index_wotd.h"(1609)
template <typename TText, class TIndexSpec, class TSpec, typename TValue > inline bool _goDownChar( Iter<Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "projects/library/seqan/index/index_wotd.h"(1631)
template <typename TIndex, class TSpec, typename TValue > inline bool _goDownChar(Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "projects/library/seqan/index/index_esa_stree.h"(1100)

//____________________________________________________________________________
// _goDownObject

template <typename TIndex, typename TSpec, typename TObject > inline bool _goDownObject( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj, False);       	// "projects/library/seqan/index/index_esa_stree.h"(1168)
template <typename TIndex, typename TSpec, typename TObject > inline bool _goDownObject( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj, True);       	// "projects/library/seqan/index/index_esa_stree.h"(1178)

//____________________________________________________________________________
// _goDownString

template <typename TIndex, typename TSpec, typename TString, typename TSize > inline bool _goDownString( Iter< TIndex, VSTree< TopDown<TSpec> > > &node, TString const &pattern, TSize &lcp);       	// "projects/library/seqan/index/index_esa_stree.h"(1118)

//____________________________________________________________________________
// _goRight

template <typename TText, typename TSpec, typename TDFSOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_wotd.h"(596)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDFSOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_wotd.h"(620)
template <typename TText, class TIndexSpec, class TSpec, typename TDFSOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDFSOrder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1289)

//____________________________________________________________________________
// _goUp

template <typename TText, typename TWotdSpec, typename TSpec > inline bool _goUp(Iter< Index<TText, Index_Wotd<TWotdSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_wotd.h"(645)
template <typename TText, typename TSpec > inline bool _goUp(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_wotd.h"(657)
template <typename TText, typename TIndexSpec, typename TSpec > inline bool _goUp(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_wotd.h"(674)
template <typename TIndex, class TSpec > inline bool _goUp(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1219)
template <typename TIndex, class TSpec > inline bool _goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1231)

//____________________________________________________________________________
// _hashFixedShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashFixedShape(THValue hash, TIter &, TValue const, FixedShape<1> const);       	// "projects/library/seqan/index/shape_base.h"(290)
template <typename THValue, typename TValue, typename TIter, unsigned q> inline THValue _hashFixedShape(THValue hash, TIter &it, TValue const, FixedShape<q> const);       	// "projects/library/seqan/index/shape_base.h"(296)

//____________________________________________________________________________
// _hashHardwiredShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashHardwiredShape(THValue hash, TIter &, TValue const, HardwiredShape< 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 > const);       	// "projects/library/seqan/index/shape_gapped.h"(448)
template <int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< 1 ,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "projects/library/seqan/index/shape_gapped.h"(465)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "projects/library/seqan/index/shape_gapped.h"(488)

//____________________________________________________________________________
// _hashTuple2FixedShape

template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, FixedShape<1> const);       	// "projects/library/seqan/index/shape_base.h"(353)
template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, FixedShape<q> const);       	// "projects/library/seqan/index/shape_base.h"(364)

//____________________________________________________________________________
// _haveMaximalRepeats

template <typename TValue, typename TSize> int _haveMaximalRepeats( _FractionCompound<TValue, TSize> const &a, _FractionCompound<TValue, TSize> const &b);       	// "projects/library/seqan/index/index_esa_algs.h"(268)
template <typename TValue, typename TSize> int _haveMaximalRepeats( _FractionCompound<TValue, TSize> const &a, _FractionCompound<TValue, TSize> const &b, TValue &equalKey);       	// "projects/library/seqan/index/index_esa_algs.h"(289)

//____________________________________________________________________________
// _historyClear

template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree<TSpec> > &);       	// "projects/library/seqan/index/index_esa_stree.h"(989)
template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(993)

//____________________________________________________________________________
// _historyPush

template <typename TText, typename TIndexSpec, typename TSpec > inline void _historyPush(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_wotd.h"(235)
template <typename TText, typename TSpec > inline void _historyPush(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_wotd.h"(244)
template <typename TText, typename TIndexSpec, typename TSpec > inline void _historyPush(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_wotd.h"(255)
template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1004)
template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1010)

//____________________________________________________________________________
// _indexRequireBottomUpIteration

template <typename TText, typename TSpec > void _indexRequireBottomUpIteration(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(298)

//____________________________________________________________________________
// _indexRequireTopDownIteration

template <typename TText, typename TSpec > void _indexRequireTopDownIteration(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(290)
template <typename TText, typename TSpec > void _indexRequireTopDownIteration(Index<TText, Index_Wotd<TSpec> > &index);       	// "projects/library/seqan/index/index_wotd.h"(193)

//____________________________________________________________________________
// _isLeaf

template <typename TText, typename TIndexSpec, typename TSpec, typename TDFSOrder > inline bool _isLeaf( Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDFSOrder, False> const);       	// "projects/library/seqan/index/index_wotd.h"(281)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDFSOrder > inline bool _isLeaf( Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDFSOrder, True> const);       	// "projects/library/seqan/index/index_wotd.h"(292)
template <typename TSize > inline bool _isLeaf(VertexESA<TSize> const &vDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(1750)
template <typename TIndex, class TSpec, typename TDFSOrder > inline bool _isLeaf( Iter<TIndex, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDFSOrder, False> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1760)
template <typename TIndex, class TSpec, typename TDFSOrder > inline bool _isLeaf( Iter<TIndex, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDFSOrder, True> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1769)

//____________________________________________________________________________
// _isNextl

template <typename TSize, typename TIndex > inline bool _isNextl(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1805)

//____________________________________________________________________________
// _isRoot

template <typename TSize > inline bool _isRoot(_VertexWotdOriginal<TSize> const &value);       	// "projects/library/seqan/index/index_wotd.h"(267)
template <typename TSize > inline bool _isRoot(_VertexWotdModified<TSize> const &value);       	// "projects/library/seqan/index/index_wotd.h"(272)
template <typename TSize > inline bool _isRoot(VertexESA<TSize> const &value);       	// "projects/library/seqan/index/index_esa_stree.h"(1501)

//____________________________________________________________________________
// _isSizeInval

template <typename TValue> inline bool _isSizeInval(TValue const &v);       	// "projects/library/seqan/index/index_base.h"(794)

//____________________________________________________________________________
// _isUp

template <typename TSize, typename TIndex > inline bool _isUp(TSize i, TIndex const &index);       	// "projects/library/seqan/index/index_esa_stree.h"(1813)

//____________________________________________________________________________
// _leqSkew3

template <typename T, typename ST> inline bool _leqSkew3(T a1, ST a2,  T b1, ST b2);       	// "projects/library/seqan/index/index_skew3.h"(313)
template <typename T, typename ST> inline bool _leqSkew3(T a1, T a2, ST a3,  T b1, T b2, ST b3);       	// "projects/library/seqan/index/index_skew3.h"(319)

//____________________________________________________________________________
// _leqSkew7

template <typename TTextIter, typename TSize> inline bool _leqSkew7(TTextIter a1, TSize a2,  TTextIter b1, TSize b2,  TSize n);       	// "projects/library/seqan/index/index_skew7.h"(414)
template <typename TTextIter, typename TSize> inline bool _leqSkew7(TTextIter a,  TTextIter b,  TSize n);       	// "projects/library/seqan/index/index_skew7.h"(425)
template <typename TTextIter, typename TSize, typename TString> inline bool _leqSkew7(unsigned a, unsigned b,  TTextIter spos[], const TSize tpos[], const bool islast[], const TString &s124, const long adjust[7][7]);       	// "projects/library/seqan/index/index_skew7.h"(436)

//____________________________________________________________________________
// _lowerBoundLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _lowerBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "projects/library/seqan/index/index_esa_find.h"(992)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1169)

//____________________________________________________________________________
// _lowerBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(524)

//____________________________________________________________________________
// _onGoDown

template <typename TIndex, typename TSpec > inline void _onGoDown(Iter<TIndex, VSTree< TopDown<TSpec> > > &);       	// "projects/library/seqan/index/index_esa_stree.h"(1018)

//____________________________________________________________________________
// _onGoRight

template <typename TIndex, typename TSpec > inline void _onGoRight(Iter<TIndex, VSTree< TopDown<TSpec> > > &);       	// "projects/library/seqan/index/index_esa_stree.h"(1021)

//____________________________________________________________________________
// _onGoUp

template <typename TIndex, typename TSpec > inline void _onGoUp(Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &);       	// "projects/library/seqan/index/index_esa_stree.h"(1024)

//____________________________________________________________________________
// _pizzaChiliDeallocate

template <typename TValue> inline void _pizzaChiliDeallocate(TValue* begin);       	// "projects/library/seqan/index/index_pizzachili_string.h"(276)

//____________________________________________________________________________
// _pizzaChiliReallocate

template <typename TValue, typename TSpec> inline typename Value<String<TValue, PizzaChili<TSpec> > >::Type* _pizzaChiliReallocate( String<TValue, PizzaChili<TSpec> >& me, typename Size<String<TValue, PizzaChili<TSpec> > >::Type new_capacity );       	// "projects/library/seqan/index/index_pizzachili_string.h"(259)

//____________________________________________________________________________
// _qgramCountQGrams

template <typename TDir, typename TText, typename TShape > inline void _qgramCountQGrams(TDir &dir, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(640)
template <typename TDir, typename TString, typename TSpec, typename TShape > inline void _qgramCountQGrams(TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(660)

//____________________________________________________________________________
// _qgramCummulativeSum

template <typename TDir, typename TWithConstraints > inline typename Value<TDir>::Type _qgramCummulativeSum(TDir &dir, TWithConstraints);       	// "projects/library/seqan/index/index_qgram.h"(690)

//____________________________________________________________________________
// _qgramCummulativeSumAlt

template <typename TDir, typename TWithConstraints > inline typename Value<TDir>::Type _qgramCummulativeSumAlt(TDir &dir, TWithConstraints const);       	// "projects/library/seqan/index/index_qgram.h"(722)

//____________________________________________________________________________
// _qgramDisableBuckets

template <typename TIndex > inline bool _qgramDisableBuckets(TIndex &);       	// "projects/library/seqan/index/index_qgram.h"(863)

//____________________________________________________________________________
// _qgramFillSuffixArray

template <typename TSA, typename TText, typename TShape, typename TDir, typename TWithConstraints > inline void _qgramFillSuffixArray(TSA &sa, TText const &text, TShape &shape, TDir &dir, TWithConstraints const);       	// "projects/library/seqan/index/index_qgram.h"(748)
template <typename TSA, typename TString, typename TSpec, typename TShape, typename TDir, typename TWithConstraints > inline void _qgramFillSuffixArray( TSA &sa, StringSet<TString, TSpec> const &stringSet, TShape &shape, TDir &dir, TWithConstraints const);       	// "projects/library/seqan/index/index_qgram.h"(790)

//____________________________________________________________________________
// _qgramPostprocessBuckets

template <typename TDir > inline void _qgramPostprocessBuckets(TDir &dir);       	// "projects/library/seqan/index/index_qgram.h"(831)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TSpec> inline typename Value<String<TValue, PizzaChili<TSpec> > >::Type* _reallocateStorage( String<TValue, PizzaChili<TSpec> >& me, typename Size<String<TValue, PizzaChili<TSpec> > >::Type new_capacity, Exact );       	// "projects/library/seqan/index/index_pizzachili_string.h"(359)

//____________________________________________________________________________
// _refineQGramIndex

template <typename TSA, typename TDir, typename TText, typename TSize1, typename TSize2 > void _refineQGramIndex( TSA &sa, TDir &dir, TText const &text, TSize1 oldQ, TSize2 newQ);       	// "projects/library/seqan/index/index_qgram.h"(1033)

//____________________________________________________________________________
// _setLength

template <typename TValue, typename TSpec> inline void _setLength( String<TValue, PizzaChili<TSpec> >& me, size_t new_length );       	// "projects/library/seqan/index/index_pizzachili_string.h"(409)

//____________________________________________________________________________
// _setSizeInval

template <typename TValue> inline void _setSizeInval(TValue &v);       	// "projects/library/seqan/index/index_base.h"(789)

//____________________________________________________________________________
// _sortBucketQuickSort

template <typename TSA, typename TText, typename TSize> void _sortBucketQuickSort( TSA &sa, TText &text, TSize lcp);       	// "projects/library/seqan/index/index_sa_qsort.h"(87)

//____________________________________________________________________________
// _sortFirstWotdBucket

template <typename TText, typename TSpec, typename TPredHull, typename TPred > typename Size< Index<StringSet<TText, TSpec>, Index_Wotd<WotdDFI<TPredHull, TPred> > > >::Type _sortFirstWotdBucket(Index<StringSet<TText, TSpec>, Index_Wotd<WotdDFI<TPredHull, TPred> > > &index);       	// "projects/library/seqan/index/index_dfi.h"(171)
template <typename TIndex > typename Size<TIndex>::Type _sortFirstWotdBucket(TIndex &index);       	// "projects/library/seqan/index/index_wotd.h"(890)
template <typename TText, typename TSpec, typename TIndexSpec > typename Size< Index<StringSet<TText, TSpec>, TIndexSpec> >::Type _sortFirstWotdBucket(Index<StringSet<TText, TSpec>, TIndexSpec> &index);       	// "projects/library/seqan/index/index_wotd.h"(935)

//____________________________________________________________________________
// _sortWotdBucket

template <typename TText, typename TSpec, typename TPredHull, typename TPred, typename TSize > TSize _sortWotdBucket( Index<StringSet<TText, TSpec>, Index_Wotd<WotdDFI<TPredHull, TPred> > > &index, TSize left, TSize right, TSize prefixLen);       	// "projects/library/seqan/index/index_dfi.h"(260)
template <typename TText, typename TSize > TSize _sortWotdBucket( Index<TText, Index_Wotd<WotdOriginal> > &index, TSize left, TSize right, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(999)
template <typename TIndex, typename TSize > TSize _sortWotdBucket( TIndex &index, TSize left, TSize right, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(1108)
template <typename TText, typename TSpec, typename TIndexSpec, typename TSize > TSize _sortWotdBucket( Index<StringSet<TText, TSpec>, TIndexSpec> &index, TSize left, TSize right, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(1171)

//____________________________________________________________________________
// _storeWotdChildren

template <typename TText, typename TPredHull, typename TPred, typename TSize> inline void _storeWotdChildren( Index<TText, Index_Wotd<WotdDFI<TPredHull, TPred> > > &index, TSize dirOfs, TSize lcp);       	// "projects/library/seqan/index/index_dfi.h"(397)
template <typename TText, typename TPos> inline void _storeWotdChildren( Index<TText, Index_Wotd<WotdOriginal> > &index, TPos dirOfs);       	// "projects/library/seqan/index/index_wotd.h"(1385)
template <typename TText, typename TSpec, typename TSize> inline void _storeWotdChildren( Index<TText, Index_Wotd<TSpec> > &index, TSize dirOfs, TSize lcp);       	// "projects/library/seqan/index/index_wotd.h"(1441)

//____________________________________________________________________________
// _treeLevels

template <typename TSize > inline unsigned _treeLevels(TSize lcpSize);       	// "projects/library/seqan/index/index_lcp_tree.h"(146)

//____________________________________________________________________________
// _upperBoundLCPE

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _upperBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "projects/library/seqan/index/index_esa_find.h"(1192)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundLCPE( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(1342)

//____________________________________________________________________________
// _upperBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "projects/library/seqan/index/index_esa_find.h"(578)

//____________________________________________________________________________
// _wotdCountChars

template <typename TBuckets, typename TText > inline void _wotdCountChars(TBuckets &buckets, TText const &text);       	// "projects/library/seqan/index/index_wotd.h"(700)
template <typename TBuckets, typename TText, typename TSpec > inline void _wotdCountChars(TBuckets &buckets, StringSet<TText, TSpec> const &stringSet);       	// "projects/library/seqan/index/index_wotd.h"(714)
template <typename TBuckets, typename TText, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountChars( TBuckets &buckets, TText const &text, TSA const &sa, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(767)
template <typename TBuckets, typename TText, typename TSpec, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountChars( TBuckets &buckets, StringSet<TText, TSpec> const &stringSet, TSA const &sa, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(803)

//____________________________________________________________________________
// _wotdCountCharsWotdOriginal

template <typename TBuckets, typename TText, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountCharsWotdOriginal( TBuckets &buckets, TText const &text, TSA &sa, TSize prefixLen);       	// "projects/library/seqan/index/index_wotd.h"(736)

//____________________________________________________________________________
// _wotdCreateFirstLevel

template <typename TText, typename TSpec> inline void _wotdCreateFirstLevel(Index<TText, Index_Wotd<TSpec> > &index);       	// "projects/library/seqan/index/index_wotd.h"(1681)

//____________________________________________________________________________
// _wotdCummulativeSum

template <typename TBounds, typename TBuckets, typename TSize > inline typename Size<TBuckets>::Type _wotdCummulativeSum(TBounds &bounds, TBuckets const &buckets, TSize offset);       	// "projects/library/seqan/index/index_wotd.h"(844)
template <typename TBounds, typename TBuckets > inline typename Size<TBuckets>::Type _wotdCummulativeSum(TBounds &bounds, TBuckets const &buckets);       	// "projects/library/seqan/index/index_wotd.h"(870)

//____________________________________________________________________________
// _wotdEvaluate

template <typename TText, typename TSpec > inline typename Size< Index<TText, Index_Wotd<WotdOriginal> > >::Type _wotdEvaluate(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_wotd.h"(1497)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, Index_Wotd<TIndexSpec> > >::Type _wotdEvaluate(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_wotd.h"(1538)

//____________________________________________________________________________
// alignment

template <typename TString, typename TSSetSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, TSSetSpec>, TIndexSpec >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(643)
template <typename TString, typename TConcSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, Owner<ConcatDirect<TConcSpec> > >, TIndexSpec >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(689)

//____________________________________________________________________________
// assign

template <typename TValue, typename TSpec, typename TSource, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, TSource const& source, Tag<TExpand> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(196)
template <typename TValue, typename TSpec, typename TSource, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, TSource const* source, Tag<TExpand> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(210)
template <typename TValue, typename TSpec, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, String<TValue, PizzaChili<TSpec> > const& source, Tag<TExpand> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(224)

//____________________________________________________________________________
// atBegin

template <typename TText, typename TSpec, typename TSpecFinder > inline bool atBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(180)

//____________________________________________________________________________
// atEnd

template <typename TText, typename TSpec > inline bool atEnd(Iter<Index<TText, Index_Wotd<WotdOriginal> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_wotd.h"(477)
template <typename TText, typename TSpec > inline bool atEnd(Iter<Index<TText, Index_Wotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_wotd.h"(483)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool atEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(188)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1467)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1473)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(824)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(829)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMEMOccurences> const &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(644)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMEMOccurences> &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(649)

//____________________________________________________________________________
// begin

template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> >, Tag<TSpec> const>::Type begin( String<TValue, PizzaChili<TSpec> >& me, Tag<TTag> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(464)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> > const, Tag<TSpec> const>::Type begin( String<TValue, PizzaChili<TSpec> > const& me, Tag<TTag> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(475)
template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type begin(Index<TText, TIndexSpec> &index, TSpec const);       	// "projects/library/seqan/index/index_esa_stree.h"(877)
template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > >::Type begin(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(579)

//____________________________________________________________________________
// bwtAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_BWT>::Type>::Type bwtAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(777)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_BWT>::Type>::Type bwtAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(781)

//____________________________________________________________________________
// cargo

template <typename TText, typename TSpec> inline typename Reference< typename Cargo<Index<TText, TSpec> >::Type >::Type cargo(Index<TText, TSpec> & me);       	// "projects/library/seqan/index/index_shims.h"(595)
template <typename TText, typename TSpec> inline typename Reference< typename Cargo<Index<TText, TSpec> const>::Type >::Type cargo(Index<TText, TSpec> const & me);       	// "projects/library/seqan/index/index_shims.h"(603)

//____________________________________________________________________________
// childAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_ChildTab>::Type>::Type childAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(756)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_ChildTab>::Type>::Type childAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(760)

//____________________________________________________________________________
// childrenAreLeaves

template <typename TIndex, class TSpec > inline bool childrenAreLeaves(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1734)

//____________________________________________________________________________
// childtab_process

template <typename TLCPInput, typename TDest > inline void childtab_process(TLCPInput &lcpIn, TDest &dest);       	// "projects/library/seqan/index/index_childtab.h"(44)

//____________________________________________________________________________
// clear

template <typename TText, typename TSpec> inline void clear(Index<TText, Index_ESA<TSpec> > &index);       	// "projects/library/seqan/index/index_esa_base.h"(307)
template <typename TText, typename TSpec> inline void clear(Index<TText, PizzaChili<TSpec> >& me);       	// "projects/library/seqan/index/index_pizzachili.h"(150)
template <typename TText, typename TSpec, typename TSpecFinder > inline void clear(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(167)
template <typename TValue, typename TSpec> inline void clear(String<TValue, PizzaChili<TSpec> >& me);       	// "projects/library/seqan/index/index_pizzachili_string.h"(178)
template <typename TIndex, class TSpec > inline void clear(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1387)

//____________________________________________________________________________
// container

template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(100)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(108)
template <typename TIndex, class TSpec > inline TIndex const & container(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(543)
template <typename TIndex, class TSpec > inline TIndex & container(Iter< TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(548)

//____________________________________________________________________________
// control

//template <typename TInput > inline bool control(Pipe< TInput, LarssonSadakane > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/index_sa_lss.h"(413)
//template <typename TInput > inline bool control(Pipe< TInput, Merger3 > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger3.h"(134)
//template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger7.h"(475)
//template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEof const &);       	// "projects/library/seqan/index/pipe_merger7.h"(483)
//template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEos const &);       	// "projects/library/seqan/index/pipe_merger7.h"(488)
//template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlBeginRead const &command);       	// "projects/library/seqan/index/pipe_merger7.h"(506)
//template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEof const &);       	// "projects/library/seqan/index/pipe_merger7.h"(513)
//template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEos const &);       	// "projects/library/seqan/index/pipe_merger7.h"(518)

//____________________________________________________________________________
// countChildren

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type countChildren(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(763)

//____________________________________________________________________________
// countOccurrences

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type countOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(600)

//____________________________________________________________________________
// countSequences

template <typename TText, typename TSpec> inline typename Size<TText>::Type countSequences(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(609)

//____________________________________________________________________________
// createBWTable

template <typename TBWT, typename TText, typename TSA > inline void createBWTable(TBWT &bwt, TText const &s, TSA const &sa);       	// "projects/library/seqan/index/index_shims.h"(439)

//____________________________________________________________________________
// createBWTableExt

template <typename TBWT, typename TText, typename TSA > void createBWTableExt( TBWT &bwt, TText const &s, TSA const &SA);       	// "projects/library/seqan/index/index_shims.h"(394)

//____________________________________________________________________________
// createBWTableInt

template <typename TBWT, typename TText, typename TSA > void createBWTableInt( TBWT &bwt, TText const &s, TSA const &SA);       	// "projects/library/seqan/index/index_bwt.h"(247)
template <typename TBWT, typename TString, typename TSpec, typename TSA > void createBWTableInt( TBWT &bwt, StringSet<TString, TSpec> const &s, TSA const &SA);       	// "projects/library/seqan/index/index_bwt.h"(275)

//____________________________________________________________________________
// createChildTable

//template <typename TLCPTable, typename TValue, typename TConfig > inline void createChildTable( String<TValue, External<TConfig> > &childtab, TLCPTable &lcp);       	// "projects/library/seqan/index/index_childtab.h"(197)
template <typename TLCPInput, typename TDest > inline void createChildTable(TDest &dest, TLCPInput const &lcpIn);       	// "projects/library/seqan/index/index_childtab.h"(209)

//____________________________________________________________________________
// createChildTableExt

template <typename TLCPTable, typename TChildTable > void createChildTableExt( TChildTable &childtab, TLCPTable &lcp);       	// "projects/library/seqan/index/index_childtab.h"(171)

//____________________________________________________________________________
// createCountsArray

template <typename TCounts, typename TDir, typename TString, typename TSpec, typename TShape > void createCountsArray( TCounts &counts, TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1150)

//____________________________________________________________________________
// createLCPBinTree

template <class LCPFwdIt, class FlatOutIt > inline FlatOutIt createLCPBinTree( LCPFwdIt _First, LCPFwdIt _Last, FlatOutIt _Dest);       	// "projects/library/seqan/index/index_lcp_tree.h"(33)
template <typename TLCPE, typename TLCP > inline void createLCPBinTree(TLCPE &lcp_enhanced, TLCP &lcp);       	// "projects/library/seqan/index/index_lcp_tree.h"(139)
//template <typename TValue, typename TConfig, typename TLCP > inline void createLCPBinTree(String<TValue, External<TConfig> > &lcp_enhanced, TLCP &lcp);       	// "projects/library/seqan/index/index_lcp_tree.h"(155)

//____________________________________________________________________________
// createLCPETable

template <typename TValue, typename TSpec, typename TText, typename TSA, typename TAlgSpec > void createLCPETable( String< TValue, TSpec > &LCPE, TText const &s, TSA const &SA, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(334)
//template <typename TValue, typename TConfig, typename TText, typename TSA, typename TAlgSpec > void createLCPETable( String< TValue, External<TConfig> > &LCPE, TText const &s, TSA const &SA, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(359)
template <typename TValue, typename TSpec, typename TText, typename TSA> inline void createLCPETable( String< TValue, TSpec > &LCPE, TText &s, TSA &SA);       	// "projects/library/seqan/index/index_shims.h"(373)

//____________________________________________________________________________
// createLCPETableExt

template <typename TValue, typename TSpec, typename TObject, typename TSA, typename TAlgSpec > void createLCPETableExt( String< TValue, TSpec > &LCPE, TObject const &text, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(301)

//____________________________________________________________________________
// createLCPTable

//template <typename TLCPTable, typename TText, typename TSA > void createLCPTable( TLCPTable &LCP, TText const &s, TSA const &SA, KasaiOriginal const);       	// "projects/library/seqan/index/index_lcp.h"(253)
//template <typename TLCPTable, typename TText, typename TSA > void createLCPTable( TLCPTable &LCP, TText const &s, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_lcp.h"(315)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA > void createLCPTable( TLCPTable &LCP, StringSet<TString, TSpec> const &sset, TSA const &SA, Kasai const);       	// "projects/library/seqan/index/index_lcp.h"(398)

//____________________________________________________________________________
// createLCPTableExt

template <typename TLCPTable, typename TObject, typename TSA, typename TAlgSpec > void createLCPTableExt( TLCPTable &LCP, TObject const &text, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(179)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA, typename TAlgSpec > void createLCPTableExt( TLCPTable &LCP, StringSet<TString, TSpec> const &stringSet, TSA const &suffixArray, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(210)

//____________________________________________________________________________
// createQGramIndex

template <typename TIndex > void createQGramIndex(TIndex &index);       	// "projects/library/seqan/index/index_qgram.h"(869)
template <typename TSA, typename TDir, typename TText, typename TShape > void createQGramIndex( TSA &sa, TDir &dir, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(915)

//____________________________________________________________________________
// createQGramIndexDirOnly

template <typename TDir, typename TText, typename TShape > void createQGramIndexDirOnly( TDir &dir, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1089)
template <typename TDir, typename TString, typename TSpec, typename TShape > void createQGramIndexDirOnly( TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1111)

//____________________________________________________________________________
// createQGramIndexExt

template <typename TSA, typename TDir, typename TText, typename TShape > void createQGramIndexExt( TSA &suffixArray, TDir &dir, TText &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(1287)
template <typename TSA, typename TDir, typename TString, typename TSpec, typename TShape, typename TLimitsString > void createQGramIndexExt( TSA &suffixArray, TDir &dir, StringSet<TString, TSpec> const &stringSet, TShape &shape, TLimitsString &limits);       	// "projects/library/seqan/index/index_qgram.h"(1374)

//____________________________________________________________________________
// createQGramIndexSAOnly

template <typename TSA, typename TText, typename TShape > void createQGramIndexSAOnly( TSA &sa, TText const &text, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(951)
template <typename TSA, typename TString, typename TSpec, typename TShape > void createQGramIndexSAOnly( TSA &sa, StringSet<TString, TSpec> const &stringSet, TShape &shape);       	// "projects/library/seqan/index/index_qgram.h"(986)

//____________________________________________________________________________
// createSABTree

template <class SAFwdIt, class FlatOutIt > inline FlatOutIt createSABTree( SAFwdIt _First, SAFwdIt _Last, FlatOutIt _Dest, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(33)
template <typename TSAB, typename TSA > inline void createSABTree(TSAB &sa_btree, TSA &sa, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(96)
//template <typename TValue, typename TConfig, typename TSA > inline void createSABTree(String<TValue, External<TConfig> > &sa_btree, TSA &sa, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(110)

//____________________________________________________________________________
// createSuffixArray

template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Shawarma<DeepShallow> const);       	// "projects/library/seqan/index/index_shawarma.h"(58)
template <typename TSA, typename TText, typename TAlgSpec > inline void createSuffixArray( TSA &SA, TText const &s, TAlgSpec const &alg);       	// "projects/library/seqan/index/index_shims.h"(121)
//template <typename TSA, typename TValue, typename TConfig, typename TAlgSpec > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > const &s, TAlgSpec const alg);       	// "projects/library/seqan/index/index_shims.h"(139)
template <typename TSA, typename TValue, typename TSpec, typename TSSetSpec, typename TAlgSpec > inline void createSuffixArray( TSA &SA, StringSet< String<TValue, TSpec>, TSSetSpec > const &s, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(155)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, LarssonSadakane const &, unsigned K);       	// "projects/library/seqan/index/index_sa_lss.h"(352)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, ManberMyers const &, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_sa_mm.h"(42)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, SAQSort const &);       	// "projects/library/seqan/index/index_sa_qsort.h"(102)
//template <typename TSA, typename TValue, typename TConfig > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > &s, Skew3 const &spec, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew3.h"(299)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew3 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "projects/library/seqan/index/index_skew3.h"(342)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew3 const &alg, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew3.h"(494)
//template <typename TSA, typename TValue, typename TConfig > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > &s, Skew7 const &spec, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew7.h"(399)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew7 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "projects/library/seqan/index/index_skew7.h"(472)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew7 const &alg, unsigned K, unsigned maxdepth);       	// "projects/library/seqan/index/index_skew7.h"(795)

//____________________________________________________________________________
// createSuffixArrayExt

template <typename TSA, typename TObject, typename TAlgSpec > void createSuffixArrayExt( TSA &suffixArray, TObject const &text, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(40)
template <typename TSA, typename TString, typename TSpec, typename TAlgSpec > void createSuffixArrayExt( TSA &suffixArray, StringSet<TString, TSpec> const &stringSet, TAlgSpec const);       	// "projects/library/seqan/index/index_shims.h"(74)

//____________________________________________________________________________
// createSuffixArrayPart

template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, ManberMyers const &alg, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_sa_mm.h"(167)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew3 const &_dummy, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_skew3.h"(508)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew7 const &_dummy, TSize maxLCP, unsigned K );       	// "projects/library/seqan/index/index_skew7.h"(809)

//____________________________________________________________________________
// dirAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_Dir>::Type>::Type dirAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_qgram.h"(265)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_Dir>::Type>::Type dirAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_qgram.h"(269)

//____________________________________________________________________________
// empty

template <typename TText, typename TSpec, typename TSpecFinder > inline bool empty(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(159)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1452)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1458)

//____________________________________________________________________________
// emptyParentEdge

template <typename TText, typename TIndexSpec, typename TSpec > inline bool emptyParentEdge(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(425)
template <typename TText, typename TIndexSpec, typename TSpec > inline bool emptyParentEdge(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(438)
template <typename TIndex, typename TSpec > inline bool emptyParentEdge(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(427)

//____________________________________________________________________________
// end

template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> >, Tag<TSpec> const>::Type end( String<TValue, PizzaChili<TSpec> >& me, Tag<TTag> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(486)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> > const, Tag<TSpec> const>::Type end( String<TValue, PizzaChili<TSpec> > const& me, Tag<TTag> const );       	// "projects/library/seqan/index/index_pizzachili_string.h"(497)
template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type end(Index<TText, TIndexSpec> &index, TSpec const);       	// "projects/library/seqan/index/index_esa_stree.h"(927)
template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > >::Type end(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(589)

//____________________________________________________________________________
// eof

template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1440)
template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1446)

//____________________________________________________________________________
// equalRangeLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1586)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1688)

//____________________________________________________________________________
// equalRangeLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1637)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1707)

//____________________________________________________________________________
// equalRangeSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(853)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(870)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(950)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(967)

//____________________________________________________________________________
// equalRangeSAIterator

template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(727)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(773)

//____________________________________________________________________________
// find

template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline bool find( Finder<Index<TText, TSpec>, TSpecFinder> &finder, TPattern const &pattern);       	// "projects/library/seqan/index/index_find.h"(249)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool find(Finder<Index<TText, TSpec>, TSpecFinder> &finder);       	// "projects/library/seqan/index/index_find.h"(260)

//____________________________________________________________________________
// findRepeats

template <typename TRepeatStore, typename TText, typename TRepeatSize, typename TPeriodSize> void findRepeats(TRepeatStore &repString, TText const &text, TRepeatSize minRepeatLen, TPeriodSize maxPeriod);       	// "projects/library/seqan/index/repeat_base.h"(92)
template <typename TRepeatStore, typename TString, typename TSpec, typename TRepeatSize> void findRepeats(TRepeatStore &repString, StringSet<TString, TSpec> const &text, TRepeatSize minRepeatLen);       	// "projects/library/seqan/index/repeat_base.h"(189)

//____________________________________________________________________________
// getFibre

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> > const, PizzaChili_Text>::Type getFibre(Index<TText, PizzaChili<TSpec> > const& me, PizzaChili_Text const);       	// "projects/library/seqan/index/index_pizzachili.h"(210)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> >, PizzaChili_Text>::Type getFibre(Index<TText, PizzaChili<TSpec> >& me, PizzaChili_Text const);       	// "projects/library/seqan/index/index_pizzachili.h"(217)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Dir>::Type & getFibre(Index<TText, TSpec> &index, Fibre_Dir);       	// "projects/library/seqan/index/index_qgram.h"(188)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Dir>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_Dir);       	// "projects/library/seqan/index/index_qgram.h"(193)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Counts>::Type & getFibre(Index<TText, TSpec> &index, Fibre_Counts);       	// "projects/library/seqan/index/index_qgram.h"(199)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Counts>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_Counts);       	// "projects/library/seqan/index/index_qgram.h"(204)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_CountsDir>::Type & getFibre(Index<TText, TSpec> &index, Fibre_CountsDir);       	// "projects/library/seqan/index/index_qgram.h"(210)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_CountsDir>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_CountsDir);       	// "projects/library/seqan/index/index_qgram.h"(215)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Shape>::Type & getFibre(Index<TText, TSpec> &index, Fibre_Shape);       	// "projects/library/seqan/index/index_qgram.h"(221)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Shape>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_Shape);       	// "projects/library/seqan/index/index_qgram.h"(226)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Text>::Type & getFibre(Index<TText, TSpec> &index, Fibre_Text);       	// "projects/library/seqan/index/index_base.h"(476)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Text>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_Text);       	// "projects/library/seqan/index/index_base.h"(481)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_RawText>::Type & getFibre(Index<TText, TSpec> &index, Fibre_RawText);       	// "projects/library/seqan/index/index_base.h"(489)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_RawText>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_RawText);       	// "projects/library/seqan/index/index_base.h"(494)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_SA>::Type & getFibre(Index<TText, TSpec> &index, Fibre_SA);       	// "projects/library/seqan/index/index_base.h"(502)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_SA>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_SA);       	// "projects/library/seqan/index/index_base.h"(507)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_SA>::Type & getFibre(Index<TText, TSpec> &index, Fibre_RawSA);       	// "projects/library/seqan/index/index_base.h"(515)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename Fibre<Index<StringSet<TString, TSSetSpec>, TSpec>, Fibre_RawSA>::Type getFibre(Index<StringSet<TString, TSSetSpec>, TSpec> &index, Fibre_RawSA);       	// "projects/library/seqan/index/index_base.h"(528)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_LCP>::Type & getFibre(Index<TText, TSpec> &index, Fibre_LCP);       	// "projects/library/seqan/index/index_base.h"(548)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_LCP>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_LCP);       	// "projects/library/seqan/index/index_base.h"(553)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_LCPE>::Type & getFibre(Index<TText, TSpec> &index, Fibre_LCPE);       	// "projects/library/seqan/index/index_base.h"(561)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_LCPE>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_LCPE);       	// "projects/library/seqan/index/index_base.h"(566)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_ChildTab>::Type & getFibre(Index<TText, TSpec> &index, Fibre_ChildTab);       	// "projects/library/seqan/index/index_base.h"(574)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_ChildTab>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_ChildTab);       	// "projects/library/seqan/index/index_base.h"(579)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_BWT>::Type & getFibre(Index<TText, TSpec> &index, Fibre_BWT);       	// "projects/library/seqan/index/index_base.h"(587)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_BWT>::Type & getFibre(Index<TText, TSpec> const &index, Fibre_BWT);       	// "projects/library/seqan/index/index_base.h"(592)

//____________________________________________________________________________
// getFrequency

template <typename TIndex, class TSpec, typename TSet > inline typename Size<TIndex>::Type getFrequency(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "projects/library/seqan/index/index_esa_stree.h"(1686)
template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type getFrequency(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1714)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TObject, typename TShapeSpec, typename TSpec, typename TDistMatrix > inline void getKmerSimilarityMatrix( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, TDistMatrix &distMat);       	// "projects/library/seqan/index/index_qgram.h"(1538)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TDistMatrix, typename TSeqNoString > inline void getKmerSimilarityMatrix( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, TDistMatrix &distMat, TSeqNoString const &seqNo);       	// "projects/library/seqan/index/index_qgram.h"(1638)

//____________________________________________________________________________
// getOccurrence

template <typename TText, typename TSpec > inline typename SAValue<Index<TText, Index_Wotd<WotdOriginal> > >::Type getOccurrence(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_wotd.h"(418)
template <typename TIndex, class TSpec > inline typename SAValue<TIndex>::Type getOccurrence(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(581)

//____________________________________________________________________________
// getOccurrences

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, Fibre_SA>::Type const >::Type getOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(621)

//____________________________________________________________________________
// getOccurrencesBWT

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, ESA_BWT>::Type const >::Type getOccurrencesBWT(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(723)

//____________________________________________________________________________
// goBegin

template <typename TText, typename TSpec, typename TSpecFinder > inline void goBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(198)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, TIndexSpec>, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(887)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(906)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goBegin(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(810)

//____________________________________________________________________________
// goDown

template <typename TIndex, class TSpec > inline bool goDown(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1085)
template <typename TIndex, typename TSpec, typename TObject > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj);       	// "projects/library/seqan/index/index_esa_stree.h"(1190)
template <typename TIndex, typename TSpec, typename TString, typename TSize > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TString const &pattern, TSize &lcp);       	// "projects/library/seqan/index/index_esa_stree.h"(1200)

//____________________________________________________________________________
// goEnd

template <typename TText, typename TSpec, typename TSpecFinder > inline void goEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(206)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(938)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, Index_ESA<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(945)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(819)

//____________________________________________________________________________
// goNext

template <typename TIndex, typename TSpec > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(956)
template <typename TIndex, typename TSpec, typename TTraits > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it, TTraits const traits);       	// "projects/library/seqan/index/index_esa_stree.h"(961)
template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<SuperMaxRepeats> > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(96)
template <typename TText, typename TSpec > inline void goNext(Iter< Index<TText, Index_ESA<TSpec> >, VSTree< BottomUp<SuperMaxRepeatsFast> > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(187)
template <typename TSTree, typename TSpec > inline void goNext(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_algs.h"(533)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goNext(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(793)
template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<MUMs> > > &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(100)
template <typename TRepeat > inline Iter<TRepeat, MultiMEMOccurences> & goNext(Iter<TRepeat, MultiMEMOccurences> &it);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(630)

//____________________________________________________________________________
// goNextImpl

template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, VSTreeIteratorTraits<_Postorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(284)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<_Preorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1405)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<_Postorder, THideEmptyEdges> const);       	// "projects/library/seqan/index/index_esa_stree.h"(1421)

//____________________________________________________________________________
// goRight

template <typename TIndex, class TSpec > inline bool goRight(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1316)

//____________________________________________________________________________
// goRoot

template <typename TText, typename TSpec > inline void goRoot(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_wotd.h"(454)
template <typename TText, typename TIndexSpec, typename TSpec > inline void goRoot(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_wotd.h"(466)
template <typename TText, typename TIndexSpec, class TSpec > inline void goRoot(Iter<Index<TText, TIndexSpec>, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(865)

//____________________________________________________________________________
// goUp

template <typename TIndex, class TSpec > inline bool goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1244)

//____________________________________________________________________________
// hash

template <typename TValue, typename TIter> inline typename Value< Shape<TValue, GappedShape> >::Type hash(Shape<TValue, GappedShape> &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(368)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hash(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_gapped.h"(385)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename TValue, typename TIter > inline typename Value< Shape<TValue, FixedGappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > >::Type hash(Shape<TValue, FixedGappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(517)
template <typename TValue, typename TIter> typename Value< Shape<TValue, SimpleShape> >::Type hash(Shape<TValue, SimpleShape> &me, TIter it);       	// "projects/library/seqan/index/shape_base.h"(271)
template <typename TValue, unsigned q, typename TIter> inline typename Value< Shape<TValue, FixedShape<q> > >::Type hash(Shape<TValue, FixedShape<q> > &me, TIter it);       	// "projects/library/seqan/index/shape_base.h"(307)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(320)
template <typename TValue, typename TTValue, unsigned SIZE, unsigned q> typename Value< Shape<TValue, FixedShape<q> > >::Type hash( Shape<TValue, FixedShape<q> > &me, Tuple<TTValue, SIZE, Compressed> const &tuple);       	// "projects/library/seqan/index/shape_base.h"(379)
template <typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> typename Value< Shape<TValue, FixedShape<q> > >::Type hash( Shape<TValue, FixedShape<q> > &me, Tuple<TTValue, SIZE, TCompressed> const &tuple);       	// "projects/library/seqan/index/shape_base.h"(400)

//____________________________________________________________________________
// hash2

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(490)

//____________________________________________________________________________
// hash2Next

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Next(Shape<TValue, TSpec> &me, TIter &it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(568)

//____________________________________________________________________________
// hash2Upper

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Upper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(519)

//____________________________________________________________________________
// hashNext

template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hashNext(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it);       	// "projects/library/seqan/index/shape_gapped.h"(536)
template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, TSpec> >::Type hashNext(Shape<TValue, TSpec> &me, TIter &it);       	// "projects/library/seqan/index/shape_base.h"(463)

//____________________________________________________________________________
// hashUpper

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, FixedGappedShape<TSpec> > >::Type hashUpper(Shape<TValue, FixedGappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_gapped.h"(413)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hashUpper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "projects/library/seqan/index/shape_base.h"(422)

//____________________________________________________________________________
// host

template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(84)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename _Parameter< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(92)

//____________________________________________________________________________
// hostIterator

template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, Fibre_SA>::Type, Standard>::Type & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(140)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, Fibre_SA>::Type, Standard>::Type const & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(148)

//____________________________________________________________________________
// indexBWT

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_BWT>::Type & indexBWT(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(932)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_BWT>::Type & indexBWT(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(934)

//____________________________________________________________________________
// indexChildTab

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_ChildTab>::Type & indexChildTab(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(948)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_ChildTab>::Type & indexChildTab(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(950)

//____________________________________________________________________________
// indexCounts

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Counts>::Type & indexCounts(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(289)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Counts>::Type & indexCounts(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(294)

//____________________________________________________________________________
// indexCountsDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_CountsDir>::Type & indexCountsDir(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(300)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_CountsDir>::Type & indexCountsDir(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(305)

//____________________________________________________________________________
// indexCreate

template <typename TText, typename TPredHull, typename TPred> inline bool indexCreate(Index<TText, Index_Wotd<WotdDFI<TPredHull, TPred> > > &index, Wotd_SA const, Default const);       	// "projects/library/seqan/index/index_dfi.h"(518)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, PizzaChili<TSpec> >& me, PizzaChili_Compressed const);       	// "projects/library/seqan/index/index_pizzachili.h"(278)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, Index_Wotd<TSpec> > &index, Wotd_SA const, Default const);       	// "projects/library/seqan/index/index_wotd.h"(1712)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Fibre_SA, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(498)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Fibre_LCP, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(506)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, Fibre_LCPE, TSpecAlg const alg);       	// "projects/library/seqan/index/index_shims.h"(514)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, Fibre_BWT, BWT const);       	// "projects/library/seqan/index/index_shims.h"(523)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, Fibre_ChildTab, ChildTab const);       	// "projects/library/seqan/index/index_shims.h"(531)
template <typename TText, typename TSpec, typename TFibre> inline bool indexCreate(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(539)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, Index_QGram<TShapeSpec, TSpec> > &index, Fibre_SADir, Default const);       	// "projects/library/seqan/index/index_qgram.h"(1459)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, Index_QGram<TShapeSpec, TSpec> > &index, Fibre_SA, Default const alg);       	// "projects/library/seqan/index/index_qgram.h"(1487)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, Index_QGram<TShapeSpec, TSpec> > &index, Fibre_Counts, Default const);       	// "projects/library/seqan/index/index_qgram.h"(1509)

//____________________________________________________________________________
// indexDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Dir>::Type & indexDir(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(243)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Dir>::Type & indexDir(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(248)

//____________________________________________________________________________
// indexLCP

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_LCP>::Type & indexLCP(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(900)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_LCP>::Type & indexLCP(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(902)

//____________________________________________________________________________
// indexLCPE

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_LCPE>::Type & indexLCPE(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(916)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_LCPE>::Type & indexLCPE(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(918)

//____________________________________________________________________________
// indexRawSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_RawSA>::Type indexRawSA(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(884)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_RawSA>::Type indexRawSA(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(886)

//____________________________________________________________________________
// indexRawText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_RawText>::Type & indexRawText(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(852)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_RawText>::Type & indexRawText(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(854)

//____________________________________________________________________________
// indexRequire

template <typename TText, typename TSpec, typename TFibre> inline bool indexRequire(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(581)

//____________________________________________________________________________
// indexSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_SA>::Type & indexSA(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(868)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_SA>::Type & indexSA(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(870)

//____________________________________________________________________________
// indexShape

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Shape>::Type & indexShape(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_qgram.h"(311)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Shape>::Type & indexShape(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_qgram.h"(316)

//____________________________________________________________________________
// indexSolveDependencies

template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, PizzaChili<TSpec> >& me, PizzaChili_Compressed const);       	// "projects/library/seqan/index/index_pizzachili.h"(242)
template <typename TText, typename TSpec, typename TFibre> inline bool indexSolveDependencies(Index<TText, TSpec> &, Tag<TFibre> const);       	// "projects/library/seqan/index/index_shims.h"(612)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Fibre_LCP);       	// "projects/library/seqan/index/index_shims.h"(618)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Fibre_LCPE);       	// "projects/library/seqan/index/index_shims.h"(624)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Fibre_ChildTab);       	// "projects/library/seqan/index/index_shims.h"(630)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, Fibre_BWT);       	// "projects/library/seqan/index/index_shims.h"(636)

//____________________________________________________________________________
// indexSupplied

template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, PizzaChili<TSpec> >& me, PizzaChili_Compressed const);       	// "projects/library/seqan/index/index_pizzachili.h"(226)
template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, PizzaChili<TSpec> >& me, PizzaChili_Text const);       	// "projects/library/seqan/index/index_pizzachili.h"(233)
template <typename TText, typename TSpec, typename TFibre> inline bool indexSupplied(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "projects/library/seqan/index/index_shims.h"(560)
template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, TSpec> &index, Fibre_SADir);       	// "projects/library/seqan/index/index_qgram.h"(1478)

//____________________________________________________________________________
// indexText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> >, PizzaChili_Text>::Type indexText(Index<TText, PizzaChili<TSpec> >& me);       	// "projects/library/seqan/index/index_pizzachili.h"(194)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> > const, PizzaChili_Text>::Type indexText(Index<TText, PizzaChili<TSpec> > const& me);       	// "projects/library/seqan/index/index_pizzachili.h"(201)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, Fibre_Text>::Type & indexText(Index<TText, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(810)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, Fibre_Text>::Type & indexText(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(812)

//____________________________________________________________________________
// infix

template <typename TValue, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<String<TValue, PizzaChili<TSpec> > >::Type infix( String<TValue, PizzaChili<TSpec> > const& me, TPosBegin begin, TPosEnd end );       	// "projects/library/seqan/index/index_pizzachili_string.h"(724)
template <typename TValue, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<String<TValue, PizzaChili<TSpec> > >::Type infix( String<TValue, PizzaChili<TSpec> >& me, TPosBegin begin, TPosEnd end );       	// "projects/library/seqan/index/index_pizzachili_string.h"(735)

//____________________________________________________________________________
// isLeaf

template <typename TIndex, class TSpec > inline bool isLeaf(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1795)

//____________________________________________________________________________
// isLeftMaximal

template <typename TIndex, class TSpec > inline bool isLeftMaximal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1541)

//____________________________________________________________________________
// isPartiallyLeftExtensible

template <typename TIndex, class TSpec, typename TSet > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it, TSet &charSet);       	// "projects/library/seqan/index/index_esa_stree.h"(1589)
template <typename TIndex, class TSpec > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1623)

//____________________________________________________________________________
// isRightTerminal

template <typename TIndex, class TSpec > inline bool isRightTerminal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1518)

//____________________________________________________________________________
// isRoot

template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1489)
template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1495)

//____________________________________________________________________________
// isUnique

template <typename TIndex, class TSpec, typename TSet > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "projects/library/seqan/index/index_esa_stree.h"(1641)
template <typename TIndex, class TSpec > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1664)

//____________________________________________________________________________
// lca

template <typename TIndex, class TSpec1, class TSpec2 > inline bool lca( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &_lca);       	// "projects/library/seqan/index/index_esa_stree.h"(456)

//____________________________________________________________________________
// lcp

template <typename TIndex, class TSpec1, class TSpec2 > inline typename Size<TIndex>::Type lcp( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b);       	// "projects/library/seqan/index/index_esa_stree.h"(507)

//____________________________________________________________________________
// lcpAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_LCP>::Type>::Type lcpAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(714)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_LCP>::Type>::Type lcpAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(718)

//____________________________________________________________________________
// lcp_process

template <typename TTextInput, typename TInvertedSAInput, typename TDest > static void lcp_process(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "projects/library/seqan/index/pump_lcp_core.h"(56)
template <typename TTextInput, typename TInvertedSAInput, typename TDest > static inline void lcp_process(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "projects/library/seqan/index/pump_lcp_core.h"(196)

//____________________________________________________________________________
// lcp_process_multi

template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void lcp_process_multi( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "projects/library/seqan/index/pump_lcp_core.h"(208)
template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void lcp_process_multi( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "projects/library/seqan/index/pump_lcp_core.h"(367)

//____________________________________________________________________________
// lcpeAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_LCPE>::Type>::Type lcpeAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(735)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_LCPE>::Type>::Type lcpeAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(739)

//____________________________________________________________________________
// length

//template <typename TInput > inline typename Size< Pipe< TInput, LarssonSadakane > >::Type length(Pipe< TInput, LarssonSadakane > const &me);       	// "projects/library/seqan/index/index_sa_lss.h"(421)
template <typename TValue, typename TSpec> inline typename Size<String<TValue, PizzaChili<TSpec> > >::Type length(String<TValue, PizzaChili<TSpec> > const& me);       	// "projects/library/seqan/index/index_pizzachili_string.h"(379)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type length(Shape<TValue, TSpec> const &me);       	// "projects/library/seqan/index/shape_base.h"(215)
template <typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type length(Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(601)
template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type length(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(570)
template <typename TSTree> inline typename Size< MaxRepeat<TSTree> >::Type length(MaxRepeat<TSTree> const &repeat);       	// "projects/library/seqan/index/index_esa_algs.h"(619)
template <typename TSTree> inline typename Size< MultiMEM<TSTree> >::Type length(MultiMEM<TSTree> const &repeat);       	// "projects/library/seqan/index/index_esa_algs_multi.h"(402)
//template <typename TInput > inline typename Size< Pipe< TInput, Merger3 > >::Type length(Pipe< TInput, Merger3 > const &me);       	// "projects/library/seqan/index/pipe_merger3.h"(145)
//template <typename TInput > inline typename Size< Pipe< TInput, Merger7 > >::Type length(Pipe< TInput, Merger7 > const &me);       	// "projects/library/seqan/index/pipe_merger7.h"(494)
//template <typename TInput, typename TLimitsString > inline typename Size< Pipe< TInput, Merger7Multi<TLimitsString> > >::Type length(Pipe< TInput, Merger7Multi<TLimitsString> > const &me);       	// "projects/library/seqan/index/pipe_merger7.h"(524)

//____________________________________________________________________________
// lowerBoundLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1554)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1656)

//____________________________________________________________________________
// lowerBoundLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type lowerBoundLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1605)

//____________________________________________________________________________
// lowerBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(793)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(807)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(890)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(904)

//____________________________________________________________________________
// lowerBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(699)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(745)

//____________________________________________________________________________
// nodeDepth

template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type nodeDepth(Iter< TIndex, VSTree<TopDown<ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(390)

//____________________________________________________________________________
// nodeHullPredicate

template <typename TText, typename TPredHull, typename TPred, typename TSpec > inline bool nodeHullPredicate( Iter<Index<TText, Index_Wotd< WotdDFI<TPredHull, TPred> > >, TSpec> const &it);       	// "projects/library/seqan/index/index_dfi.h"(158)
template <typename TIndex, class TSpec > inline bool nodeHullPredicate(Iter<TIndex, TSpec> &);       	// "projects/library/seqan/index/index_esa_stree.h"(857)
template <typename TText, typename TSpec> bool nodeHullPredicate(Iter<Index<TText, Index_Wotd<TRepeatFinder> >, TSpec> &it);       	// "projects/library/seqan/index/repeat_base.h"(75)

//____________________________________________________________________________
// nodePredicate

template <typename TText, typename TPredHull, typename TPred, typename TSpec > inline bool nodePredicate( Iter<Index<TText, Index_Wotd< WotdDFI<TPredHull, TPred> > >, TSpec> const &it);       	// "projects/library/seqan/index/index_dfi.h"(145)
template <typename TIndex, class TSpec > inline bool nodePredicate(Iter<TIndex, TSpec> &);       	// "projects/library/seqan/index/index_esa_stree.h"(839)
template <typename TText, typename TSpec> bool nodePredicate(Iter<Index<TText, Index_Wotd<TRepeatFinder> >, TSpec> &it);       	// "projects/library/seqan/index/repeat_base.h"(67)

//____________________________________________________________________________
// nodeUp

template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type nodeUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1256)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type const & nodeUp(Iter< TIndex, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1271)

//____________________________________________________________________________
// open

template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_esa_base.h"(324)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_esa_base.h"(340)
template <typename TText, typename TSpec> inline bool open( Index<TText, PizzaChili<TSpec> >& me, char const* filename );       	// "projects/library/seqan/index/index_pizzachili.h"(334)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(646)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(654)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(660)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(668)
template <typename TValue, typename TSpec, typename TSSSpec > inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(674)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(694)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool open( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_qgram.h"(1755)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool open( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_qgram.h"(1769)

//____________________________________________________________________________
// operator!=

template <typename TRepeat > inline bool operator!= ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "projects/library/seqan/index/index_esa_algs.h"(851)

//____________________________________________________________________________
// operator<<

//template <typename TInput, typename TObject, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Skew7, TPair, TLimitsString> > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew7_multi.h"(404)
//template <typename TInput, typename _TLCPInput > inline bool operator<<(Pipe< TInput, ChildTab > &me, _TLCPInput const &in);       	// "projects/library/seqan/index/index_childtab.h"(162)
//template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput > inline bool operator<<(Pipe< TInput, Kasai > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_lcp.h"(131)
//template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Kasai, TPair, TLimitsString> > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_lcp.h"(234)
//template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew3 > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew3.h"(285)
//template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput > inline bool operator<<(Pipe< TInput, BWT > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_bwt.h"(113)
//template <typename TInput, typename _TTextInput, typename _TSuffixArrayInput, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<BWT, TPair, TLimitsString> > &me, Bundle2< _TTextInput, _TSuffixArrayInput > const &bundleIn);       	// "projects/library/seqan/index/index_bwt.h"(229)
//template <typename TValue> std::ostream& operator<<(std::ostream &out, const SkewDCStream<TValue> &s);       	// "projects/library/seqan/index/pipe_merger7.h"(77)
//template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew7 > &me, TObject &textIn);       	// "projects/library/seqan/index/index_skew7.h"(385)

//____________________________________________________________________________
// operator==

template <typename TRepeat > inline bool operator== ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "projects/library/seqan/index/index_esa_algs.h"(840)

//____________________________________________________________________________
// orderOccurrences

template <typename TValue, typename TSpec> inline void orderOccurrences(String<TValue, TSpec> &occString);       	// "projects/library/seqan/index/index_shims.h"(474)

//____________________________________________________________________________
// parentEdgeFirstChar

template <typename TIndex, class TSpec > inline typename Value<TIndex>::Type parentEdgeFirstChar(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1377)

//____________________________________________________________________________
// parentEdgeLabel

template <typename TText, typename TSpec > inline typename Infix< typename Fibre<Index<TText, Index_Wotd<WotdOriginal> >, ESA_RawText>::Type const >::Type parentEdgeLabel(Iter< Index<TText, Index_Wotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(401)
template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, Fibre_Text>::Type const >::Type parentEdgeLabel(Iter< TIndex, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1357)

//____________________________________________________________________________
// parentEdgeLength

template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type parentEdgeLength(TIndex const &index, _VertexWotdOriginal<TSize> &vDesc);       	// "projects/library/seqan/index/index_wotd.h"(309)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type parentEdgeLength(TIndex const &index, _VertexWotdModified<TSize> &vDesc);       	// "projects/library/seqan/index/index_wotd.h"(332)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, Index_Wotd<TIndexSpec> > >::Type parentEdgeLength(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(364)
template <typename TText, class TIndexSpec, class TSpec > inline typename Size< Index<TText, Index_ESA<TIndexSpec> > >::Type parentEdgeLength(Iter< Index<TText, Index_ESA<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(1339)

//____________________________________________________________________________
// parentRepLength

template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, Index_Wotd<TIndexSpec> > >::Type parentRepLength(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(374)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, Index_Wotd<TIndexSpec> > >::Type parentRepLength(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(383)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type parentRepLength(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(408)

//____________________________________________________________________________
// position

template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "projects/library/seqan/index/index_find.h"(226)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "projects/library/seqan/index/index_find.h"(235)

//____________________________________________________________________________
// prefix

template <typename TValue, typename TSpec, typename TPos> inline typename Prefix<String<TValue, PizzaChili<TSpec> > >::Type prefix( String<TValue, PizzaChili<TSpec> > const& me, TPos end );       	// "projects/library/seqan/index/index_pizzachili_string.h"(747)
template <typename TValue, typename TSpec, typename TPos> inline typename Prefix<String<TValue, PizzaChili<TSpec> > >::Type prefix( String<TValue, PizzaChili<TSpec> >& me, TPos end );       	// "projects/library/seqan/index/index_pizzachili_string.h"(757)

//____________________________________________________________________________
// radixExtend

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtend( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(118)

//____________________________________________________________________________
// radixExtendClip

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtendClip( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(153)

//____________________________________________________________________________
// radixPass

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "projects/library/seqan/index/radix.h"(39)
template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText, typename TShift > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K, TShift shift);       	// "projects/library/seqan/index/radix.h"(75)

//____________________________________________________________________________
// rawsaAt

template <typename TPos, typename TIndex> inline typename Value<typename Fibre<TIndex const, Fibre_RawSA>::Type>::Type rawsaAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(696)

//____________________________________________________________________________
// rawtextAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_RawText>::Type>::Type rawtextAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(666)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_RawText>::Type>::Type rawtextAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(670)

//____________________________________________________________________________
// repLength

template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, Index_Wotd<TIndexSpec> > >::Type repLength(Iter< Index<TText, Index_Wotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_wotd.h"(392)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<BottomUp<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(355)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type repLength(TIndex const &index, VertexESA<TSize> const &vDesc);       	// "projects/library/seqan/index/index_esa_stree.h"(367)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(383)
template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type repLength(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(562)

//____________________________________________________________________________
// representative

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, Fibre_Text>::Type const >::Type representative(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(744)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSize> inline typename Size< Shape<TValue, SimpleShape> >::Type resize(Shape<TValue, SimpleShape> & me, TSize new_length);       	// "projects/library/seqan/index/shape_base.h"(246)

//____________________________________________________________________________
// saAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_SA>::Type>::Type saAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(687)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, Fibre_SA>::Type>::Type saAt(TPos i, TIndex const &index);       	// "projects/library/seqan/index/index_base.h"(691)

//____________________________________________________________________________
// save

template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_esa_base.h"(353)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, Index_ESA<TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_esa_base.h"(369)
template <typename TText, typename TSpec> inline bool save( Index<TText, PizzaChili<TSpec> >& me, char const* filename );       	// "projects/library/seqan/index/index_pizzachili.h"(352)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> const &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(704)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(714)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(720)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(729)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_shims.h"(735)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName);       	// "projects/library/seqan/index/index_shims.h"(750)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool save( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, const char *fileName, int openMode);       	// "projects/library/seqan/index/index_qgram.h"(1782)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool save( Index< TObject, Index_QGram<TShapeSpec, TSpec> > &index, const char *fileName);       	// "projects/library/seqan/index/index_qgram.h"(1796)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type sequenceLength(TSeqNo seqNo, Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(617)

//____________________________________________________________________________
// setContainer

template <typename TText, typename TSpec, typename TSpecFinder > inline void setContainer( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename _Parameter<Index<TText, TSpec> >::Type container_);       	// "projects/library/seqan/index/index_find.h"(130)

//____________________________________________________________________________
// setHost

template <typename TText, typename TSpec, typename TSpecFinder > inline void setHost( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename _Parameter<Index<TText, TSpec> >::Type container_);       	// "projects/library/seqan/index/index_find.h"(120)

//____________________________________________________________________________
// setIndexText

template <typename TText, typename TSpec, typename TOtherText> inline void setIndexText(Index<TText, PizzaChili<TSpec> >& me, TOtherText& text);       	// "projects/library/seqan/index/index_pizzachili.h"(303)

//____________________________________________________________________________
// sizeofLCPE

template <typename TSize > inline TSize sizeofLCPE(TSize n);       	// "projects/library/seqan/index/index_lcp_tree.h"(105)
template <class LCPFwdIt, typename TSize > inline void sizeofLCPE(LCPFwdIt _First, LCPFwdIt _Last, TSize &_Size);       	// "projects/library/seqan/index/index_lcp_tree.h"(124)

//____________________________________________________________________________
// sizeofLCPH

template <typename TSize > inline TSize sizeofLCPH(TSize n);       	// "projects/library/seqan/index/index_lcp_tree.h"(116)
template <class LCPFwdIt, typename TSize > inline void sizeofLCPH(LCPFwdIt _First, LCPFwdIt _Last, TSize &_Size);       	// "projects/library/seqan/index/index_lcp_tree.h"(132)

//____________________________________________________________________________
// sizeofSAB

template <typename TSize > inline TSize sizeofSAB(TSize n, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(79)
template <class SAFwdIt, typename TSize > inline void sizeofSAB(SAFwdIt _First, SAFwdIt _Last, TSize &_Size, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(90)

//____________________________________________________________________________
// skew3_extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut12 > static bool skew3_extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut12 &out12);       	// "projects/library/seqan/index/pump_extender3.h"(54)

//____________________________________________________________________________
// skew7_extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool skew7_extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "projects/library/seqan/index/pump_extender7.h"(75)

//____________________________________________________________________________
// skew7_extend_multi

template <typename TTextInput, typename TLimitsString, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool skew7_extend_multi( TTextInput &textIn, TLimitsString const &limits, TNameInput &nameIn1, TNameInput &nameIn2, TNameInput &nameIn4, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "projects/library/seqan/index/pump_extender7.h"(265)

//____________________________________________________________________________
// skew7_separate_slices

template <typename TInput, typename TFunctor, typename TOut1, typename TOut2, typename TOut4 > static void skew7_separate_slices( TInput &in, TFunctor const &funcSlice, TOut1 &out1, TOut2 &out2, TOut4 &out4);       	// "projects/library/seqan/index/pump_separator7.h"(35)

//____________________________________________________________________________
// stringSetLimits

template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> &);       	// "projects/library/seqan/index/index_base.h"(818)
template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> const &);       	// "projects/library/seqan/index/index_base.h"(824)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(830)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(836)

//____________________________________________________________________________
// stringToShape

template <typename TValue, typename TSpec, typename TShapeString> inline void stringToShape( Shape<TValue, FixedGappedShape<TSpec> > &me, TShapeString const &bitmap);       	// "projects/library/seqan/index/shape_gapped.h"(561)

//____________________________________________________________________________
// suffix

template <typename TValue, typename TSpec, typename TPos> inline typename Suffix<String<TValue, PizzaChili<TSpec> > >::Type suffix( String<TValue, PizzaChili<TSpec> > const& me, TPos begin );       	// "projects/library/seqan/index/index_pizzachili_string.h"(769)
template <typename TValue, typename TSpec, typename TPos> inline typename Suffix<String<TValue, PizzaChili<TSpec> > >::Type suffix( String<TValue, PizzaChili<TSpec> >& me, TPos begin );       	// "projects/library/seqan/index/index_pizzachili_string.h"(779)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type suffixLength(TPos pos, Index<TText, TSpec> const &index);       	// "projects/library/seqan/index/index_base.h"(625)

//____________________________________________________________________________
// textAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, Fibre_RawText>::Type>::Type textAt(TPos i, TIndex &index);       	// "projects/library/seqan/index/index_base.h"(635)
template <typename TPos, typename TString, typename TSSetSpec, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, TSSetSpec>, TSpec>, Fibre_RawText>::Type>::Type textAt(TPos i, Index< StringSet<TString, TSSetSpec>, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(640)
template <typename TPos, typename TString, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, Owner<Default> >, TSpec>, Fibre_RawText>::Type>::Type textAt(TPos i, Index< StringSet<TString, Owner<Default> >, TSpec> &index);       	// "projects/library/seqan/index/index_base.h"(645)

//____________________________________________________________________________
// treeLevelsSAB

template <typename TSize > inline unsigned treeLevelsSAB(TSize saSize, unsigned BlockSize);       	// "projects/library/seqan/index/index_sa_btree.h"(103)

//____________________________________________________________________________
// unhash

template <typename TString, typename THash> inline void unhash(TString &result, THash hash, unsigned q);       	// "projects/library/seqan/index/shape_base.h"(593)

//____________________________________________________________________________
// upperBoundLCPE

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1570)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLCPE( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(1672)

//____________________________________________________________________________
// upperBoundLCPEIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type upperBoundLCPEIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(1621)

//____________________________________________________________________________
// upperBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(823)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(837)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "projects/library/seqan/index/index_esa_find.h"(920)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(934)

//____________________________________________________________________________
// upperBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "projects/library/seqan/index/index_esa_find.h"(713)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "projects/library/seqan/index/index_esa_find.h"(759)

//____________________________________________________________________________
// value

template <typename TValue, typename TSpec> inline typename Value< Shape<TValue, TSpec> >::Type value(Shape<TValue, TSpec> &me);       	// "projects/library/seqan/index/shape_base.h"(205)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type & value(Iter< TIndex, VSTree<TSpec> > &it);       	// "projects/library/seqan/index/index_esa_stree.h"(557)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type const & value(Iter< TIndex, VSTree<TSpec> > const &it);       	// "projects/library/seqan/index/index_esa_stree.h"(563)
template <typename TSTree, typename TSpec > inline typename VertexDescriptor<TSTree>::Type value(Iter< TSTree, VSTree< BottomUp<_MaxRepeats<TSpec> > > > const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(551)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "projects/library/seqan/index/index_esa_algs.h"(780)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "projects/library/seqan/index/index_esa_algs.h"(786)

//____________________________________________________________________________
// weight

template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, FixedGappedShape<TSpec> > >::Type weight(Shape<TValue, FixedGappedShape<TSpec> > const & me);       	// "projects/library/seqan/index/shape_gapped.h"(358)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type weight(Shape<TValue, TSpec> const &me);       	// "projects/library/seqan/index/shape_base.h"(235)

//____________________________________________________________________________
// write

template <typename TFile, typename TText, typename TESASpec> void write(TFile & file, Index<TText, Index_ESA<TESASpec> > & stree, DotDrawing);       	// "projects/library/seqan/index/index_esa_drawing.h"(31)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

