/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REMOTE_QUERY_PLUGIN_TEST_H_
#define _U2_REMOTE_QUERY_PLUGIN_TEST_H_

#include <U2Test/XMLTestUtils.h>
#include "RemoteBLASTTask.h"


namespace U2 {

class GTest_RemoteBLAST : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_RemoteBLAST, "plugin_remote-query");

    void prepare();
    void cleanup();
    Task::ReportResult report();
private:
    AnnotationTableObject *ao;
    RemoteBLASTToAnnotationsTask *task;
    int minLength;
    int maxLength;
    QString index;
    QString sequence;
    QString request;
    QString algoritm;
    QStringList expectedResults;
};

}//ns

#endif
