/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _DB_REQUEST_FACTORY_
#define _DB_REQUEST_FACTORY_

#include <U2Core/DataBaseRegistry.h>

#include "HttpRequest.h"

namespace U2 {

class BLASTFactory: public DataBaseFactory {
    HttpRequest* getRequest(Task *t) {return new HttpRequestBLAST(t);}
};

class CDDFactory: public DataBaseFactory {
    HttpRequest* getRequest(Task* t) {return new HttpRequestCDD(t);}
};

}


#endif