/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_GENOME_ALIGNER_INDEX_H_
#define _U2_GENOME_ALIGNER_INDEX_H_

#include <U2Core/Task.h>
#include <U2Algorithm/BitsTable.h>
#include <QtCore/QFile>

namespace U2 {

class GenomeAlignerIndex {
    friend class GenomeAlignerIndexTask;
public:
    class SAISearchContext {
    public:
        const char* query;
        quint64     bitValue;
    };
    GenomeAlignerIndex();
    ~GenomeAlignerIndex();

    quint64 getBitValue(const char *seq) const;
    int getPrefixSize() const;
    const char *getIndexedSequence() const;
    int findInCache(const SAISearchContext &c) const;

private:
    const char      *seq;           //reference sequence
    quint32         seqLength;      //reference sequence's length
    int             w;              //window size
    QString         baseFileName;   //base of the file name
    quint32         indexLength;    //count of index's elements
    quint32         *sArray;
    quint64         *bitMask;
    quint32         *memSA;
    quint64         *memBM;
    BitsTable       bt;
    const quint32*  bitTable;
    int             bitCharLen;
    int             wCharsInMask;
    int             wAfterBits;
    QFile           *indexFile;
    int             partsInMemCache;
    quint32         *objLens;
    int             objCount;

    void serialize(const QString &refFileName);
    void deserialize(TaskStateInfo& ti);
    bool openIndexFile();
    void createMemCache();
    inline qint64 compareWithoutArrays(quint64 x1, quint64 x2, quint32 a1, quint32 a2, const char *seq) const;
    inline int compareAfterBits(quint32 bitMaskPos, const char* query) const;

    static const QString HEADER_EXTENSION;
    static const QString SARRAY_EXTENSION;
    static const QString REF_INDEX_EXTENSION;
    static const QString HEADER;
    static const QString PARAMETERS;

};

} //namespace

#endif
