/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_GENOME_ALIGNER_FIND_TASK_H_
#define _U2_GENOME_ALIGNER_FIND_TASK_H_

#include <U2Core/Task.h>
#include <U2Core/LRegion.h>

#include <QtCore/QMutex>

namespace U2 {

class SArrayIndex;
struct SArrayBasedSearchSettings;
class GenomeAlignerIndex;

class CacheResult {
public:
    int posAtShortRead;
    int numberOfPart;
};

class SearchQuery {
public:
    QByteArray shortRead;
    quint64 bitValue;
    QList<CacheResult> cacheResults; //must be sorted by numberOfPart
    QList<int> results;
};

class SearchSettings {
public:
    int ptMismatches;
    int nMismatches;
    bool absMismatches;
    QList<SearchQuery*> queries;
};

#define MAX_PERCENTAGE 100
class FindTask : public Task {
    Q_OBJECT
public:
    FindTask(GenomeAlignerIndex *i, const SearchSettings &s);
    virtual void run();
    virtual void cleanup();

private:
    GenomeAlignerIndex *index;
    SearchSettings *settings;
};

class GenomeAlignerFindTask : public Task {
    Q_OBJECT
public:
    GenomeAlignerFindTask(SArrayIndex* i, const SArrayBasedSearchSettings& s, bool onlyFirstMatch = false);
    virtual void run();
    virtual void cleanup();
    const QList<int> getResults() const { return results; }

private:
    void runSearch();
    SArrayIndex* index;
    SArrayBasedSearchSettings* config;
    QList<int> results;
    QMutex lock;
    bool onlyFirstMatch;
};

} //namespace

#endif // _U2_GENOME_ALIGNER_FIND_TASK_H_
