/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ExternalToolRunTask.h"

#include <U2Core/AppContext.h>
#include <U2Core/ExternalToolRegistry.h>
#include <U2Core/Log.h>
#include <QtCore/QString>

namespace U2 {

ExternalToolRunTask::ExternalToolRunTask(const QString& _toolName, const QStringList& _arguments, ExternalToolLogParser*  _logParser) :
        Task(_toolName + " run task", TaskFlag_None), arguments(_arguments), logParser(_logParser), toolName(_toolName)
{
    program=AppContext::getExternalToolRegistry()->getByName(toolName)->getPath();
    coreLog.trace("Creating run task for: " + toolName);
    logData=(char*)malloc(1000*sizeof(char));
    externalToolProcess=NULL;
}
ExternalToolRunTask::~ExternalToolRunTask(){
    free(logData);
    logData=NULL;
    delete externalToolProcess;
    externalToolProcess=NULL;
}
void ExternalToolRunTask::prepare(){
    externalToolProcess=new QProcess();//???
    connect(externalToolProcess,SIGNAL(readyReadStandardOutput()),SLOT(sl_onReadyToReadLog()));
    connect(externalToolProcess,SIGNAL(readyReadStandardError()),SLOT(sl_onReadyToReadErrLog()));
    algoLog.trace("Program executable: "+program);
    algoLog.trace("Program arguments: "+arguments.join(" "));
}
void ExternalToolRunTask::run(){
    externalToolProcess->start(program, arguments);
    //externalToolProcess->state()
    if(!externalToolProcess->waitForStarted(3000)){
        stateInfo.setError(tr("Can not run %1 tool.").arg(toolName));
        return;
    }
    while(!externalToolProcess->waitForFinished(1000)){
        if (isCanceled()) {
            cancelProcess();
        }
    }
}
Task::ReportResult ExternalToolRunTask::report(){
    return ReportResult_Finished;
}
void ExternalToolRunTask::cancelProcess(){
    externalToolProcess->kill();
}

void ExternalToolRunTask::sl_onReadyToReadLog(){
    if(externalToolProcess->readChannel() == QProcess::StandardError)
        externalToolProcess->setReadChannel(QProcess::StandardOutput);
    int numberReadChars=externalToolProcess->read(logData,1000);
    while(numberReadChars > 0){
        //call log parser
        logParser->parseOutput(QString(logData).left(numberReadChars));
        numberReadChars=externalToolProcess->read(logData,1000);
    }
    stateInfo.progress=logParser->getProgress();
    emit si_progressChanged();
}

void ExternalToolRunTask::sl_onReadyToReadErrLog(){
    if(externalToolProcess->readChannel() == QProcess::StandardOutput)
        externalToolProcess->setReadChannel(QProcess::StandardError);
    int numberReadChars=externalToolProcess->read(logData,1000);
    while(numberReadChars > 0){
        //call log parser
        logParser->parseErrOutput(QString(logData).left(numberReadChars));
        numberReadChars=externalToolProcess->read(logData,1000);
    }
    stateInfo.progress=logParser->getProgress();
    emit si_progressChanged();
}
////////////////////////////////////////
//ExternalToolLogParser
ExternalToolLogParser::ExternalToolLogParser() {
    progress=-1;
    lastLine="";
    lastErrLine="";
}
void ExternalToolLogParser::parseOutput(const QString& partOfLog){
    lastPartOfLog=partOfLog.split(QChar('\n'));
    lastPartOfLog.first()=lastLine+lastPartOfLog.first();
    lastLine=lastPartOfLog.takeLast();
    foreach(QString buf, lastPartOfLog){
        if(buf.contains("error",Qt::CaseInsensitive)){
            ioLog.error(buf);
        }else{
            ioLog.trace(buf);
        }
    }
}

void ExternalToolLogParser::parseErrOutput(const QString& partOfLog){
    lastPartOfLog=partOfLog.split(QChar('\n'));
    lastPartOfLog.first()=lastErrLine+lastPartOfLog.first();
    lastErrLine=lastPartOfLog.takeLast();
    foreach(const QString& buf, lastPartOfLog){
        if(buf.contains("error",Qt::CaseInsensitive)){
            ioLog.error(buf);
        }else{
            ioLog.trace(buf);
        }
    }
}
}//namespace
