/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DNAStatPlugin.h"
#include "DNAStatMSAProfileDialog.h"
#include "DistanceMatrixMSAProfileDialog.h"

#include <U2Core/AppContext.h>

#include <U2Gui/GUIUtils.h>
#include <U2View/MSAEditor.h>
#include <U2View/MSAEditorFactory.h>

#include <QtGui/QMenu>
#include <QtCore/QMap>
#include <QtGui/QAction>

namespace U2 {

extern "C" Q_DECL_EXPORT Plugin* U2_PLUGIN_INIT_FUNC() {
    if (AppContext::getMainWindow()) {
        DNAStatPlugin* plug = new DNAStatPlugin();
        return plug;
    }
    return NULL;
}

DNAStatPlugin::DNAStatPlugin() : Plugin(tr("DNA Statistics"), tr("Provides statistical reports for sequences and alignments"))
{
    statViewCtx = new DNAStatMSAEditorContext(this);
    statViewCtx->init();
    distanceViewCtx = new DistanceMatrixMSAEditorContext(this);
    distanceViewCtx->init();
}


DNAStatMSAEditorContext::DNAStatMSAEditorContext(QObject* p) : 
GObjectViewWindowContext(p, MSAEditorFactory::ID) {}

void DNAStatMSAEditorContext::initViewContext(GObjectView* v) {
    MSAEditor* msaed = qobject_cast<MSAEditor*>(v);
    if (msaed != NULL && !msaed->getMSAObject())
        return;

    GObjectViewAction* profileAction = new GObjectViewAction(this, v, tr("Generate grid profile"));
    connect(profileAction, SIGNAL(triggered()), SLOT(sl_showMSAProfileDialog()));
    addViewAction(profileAction);
}

void DNAStatMSAEditorContext::buildMenu(GObjectView* v, QMenu* m) {
    MSAEditor* msaed = qobject_cast<MSAEditor*>(v);
    if (msaed != NULL && !msaed->getMSAObject())
        return;

    QList<GObjectViewAction *> actions = getViewActions(v);
    QMenu* statMenu = GUIUtils::findSubMenu(m, MSAE_MENU_STATISTICS);
    assert(statMenu!=NULL);
    foreach(GObjectViewAction* a, actions) {
        statMenu->addAction(a);
    }    
}

void DNAStatMSAEditorContext::sl_showMSAProfileDialog() {
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(sender());
    MSAEditor* msaEd = qobject_cast<MSAEditor*>(viewAction->getObjectView());
    DNAStatMSAProfileDialog d(msaEd->getWidget(), msaEd);
    d.exec();
}

DistanceMatrixMSAEditorContext::DistanceMatrixMSAEditorContext(QObject* p) : 
GObjectViewWindowContext(p, MSAEditorFactory::ID) {}

void DistanceMatrixMSAEditorContext::initViewContext(GObjectView* v) {
    MSAEditor* msaed = qobject_cast<MSAEditor*>(v);
    if (msaed != NULL && !msaed->getMSAObject())
        return;

    GObjectViewAction* profileAction = new GObjectViewAction(this, v, tr("Generate distance matrix"));
    connect(profileAction, SIGNAL(triggered()), SLOT(sl_showDistanceMatrixDialog()));
    addViewAction(profileAction);
}

void DistanceMatrixMSAEditorContext::buildMenu(GObjectView* v, QMenu* m) {
    MSAEditor* msaed = qobject_cast<MSAEditor*>(v);
    if (msaed != NULL && !msaed->getMSAObject())
        return;

    QList<GObjectViewAction *> actions = getViewActions(v);
    QMenu* statMenu = GUIUtils::findSubMenu(m, MSAE_MENU_STATISTICS);
    assert(statMenu!=NULL);
    foreach(GObjectViewAction* a, actions) {
        statMenu->addAction(a);
    }    
}

void DistanceMatrixMSAEditorContext::sl_showDistanceMatrixDialog() {
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(sender());
    MSAEditor* msaEd = qobject_cast<MSAEditor*>(viewAction->getObjectView());
    DistanceMatrixMSAProfileDialog d(msaEd->getWidget(), msaEd);
    d.exec();
}



}//namespace

