/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_ANNOTATION_H_
#define _U2_ANNOTATION_H_

#include <U2Core/U2Type.h>
#include <U2Core/U2Region.h>

#include <QtCore/QStringList>

namespace U2 {


/**
    Annotation qualifier - a textual property/remark for annotation
*/
class U2CORE_EXPORT U2Qualifier {
public:
    /** Name of the qualified */
    QString name;

    /** Value of the qualifier */
    QString value;
};

/** 
    For annotation with multiple regions in location this flag tells how to process joins
*/
enum U2LocationOperatorFlag {
    /** Default value for empty operators */
    U2LocationOperator_None = 0,
    /** Location elements must be joined */
    U2LocationOperator_Join = 1,
    /** No need to join location elements */
    U2LocationOperator_Order = 1 << 1,
};
typedef QFlags<U2LocationOperatorFlag> U2LocationOperator;


/** 
    Flags for single location region 
*/
enum U2LocationRegionDescriptor {
    
    /** empty operator */
    U2LocationRegionDescriptor_Default = 0,

    /** a site between indicated adjoining bases */
    U2LocationRegionDescriptor_Site = 1 << 1, 

    /** a single base chosen from within a specified range of bases (not allowed for new entries) */
    U2LocationRegionDescriptor_SingleBase = 1 << 2,
    
    /** a remote entry identifier followed by a local location descriptor */
    U2LocationRegionDescriptor_RemoteEntry = 1 << 3
};


/** Location element */
class U2CORE_EXPORT U2LocationRegion {
public:
    U2LocationRegion() : descriptor (U2LocationRegionDescriptor_Default), strand(U2Strand_Direct), truncateLeft(false), truncateRight(false) {}
    
    /** The annotated region */
    U2Region                    region;
    
    /** Descriptor of the region: no special info, site, remote... */
    U2LocationRegionDescriptor  descriptor;
    
    /** 
        Strand of the location. U2Strand_Irrelevant means that 
        no strand operation will be applied in the most cases and is equal to U2Strand_Direct 
    */
    U2Strand                    strand;
    
    /** Annotation region extends further to the left */
    bool                        truncateLeft;
    
    /** Annotation region extends further to the right  */
    bool                        truncateRight;
    
    /** Remote database id */
    QByteArray                  remote;
}; 

/** Annotation location */
class U2CORE_EXPORT U2Location {
public:
    U2Location() : op (U2LocationOperator_None) {}

    /** Location operator */
    U2LocationOperator op;

    /** Annotated regions coordinates */
    QList<U2LocationRegion>  location;
};

/** 
    Sequence annotation. Used to annotate set of sequence regions
*/
class U2CORE_EXPORT U2Annotation : public U2Entity {
public:
    /** Sequence this annotation is related to */
    U2DataId                sequenceId;
    
    /** Key (name) of the annotation */
    QString                 key;
    
    /** Annotation location */
    U2Location              location;

    /** Annotation related qualifiers (textual properties) */
    QList<U2Qualifier>      qualifiers;

    /** 
        Groups (folders) this annotation must is shown in. 
        Annotation must belong to at least one group, otherwise it is automatically removed.
    */
    QStringList             annotationGroups;
};


} //namespace

#endif
