/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _SMITH_WATERMAN_SCHEMA_TASK_H_
#define _SMITH_WATERMAN_SCHEMA_TASK_H_

#include <U2Algorithm/SmithWatermanSettings.h>

#include <U2Core/Task.h>
#include <U2Core/DocumentModel.h>
#include <U2Core/SaveDocumentTask.h>
#include <U2Core/LoadDocumentTask.h>
//#include <U2Lang/RunSchemaForTask.h>
//#include <U2Remote/RemoteMachine.h>
#include <U2Remote/RemoteWorkflowRunTask.h>

namespace U2
{

class SmithWatermanSchemaTask: public Task
{
    Q_OBJECT

public:
    SmithWatermanSchemaTask(const SmithWatermanSettings &swSettings,
                            AnnotationTableObject *annotationObj, const QString &aname, const QString &agroup);
    virtual ~SmithWatermanSchemaTask();

protected:
    virtual RunSchemaForTask* prepareRunSchemaTask();
    LoadDocumentTask* prepareOpenResultFileTask();

    virtual void prepare();
    virtual QList<Task*> onSubTaskFinished(Task *subTask);

    QVariantMap convertSWSettings(const SmithWatermanSettings &settings);

private:
    Document* createInputDocument();

protected:
    static const QString SCHEMA_NAME;
    const DocumentFormatId IO_FORMATID;

protected:
    QVariantMap schemaParameters;
    QString tempSubDir;
    QString inFile, outFile;

private:
    SmithWatermanSettings swSettings;
    QPointer<AnnotationTableObject>   annotationObj;
    QString aname;
    QString agroup;
    RunSchemaForTask *runTask;
    SaveDocumentTask *saveInputFileTask;
    LoadDocumentTask *openResultFileTask;

};    // class SmithWatermanSchemaTask


class SmithWatermanSchemaRemoteTask : public SmithWatermanSchemaTask
{
public:
    SmithWatermanSchemaRemoteTask(RemoteMachineSettings *rms_, const SmithWatermanSettings &swSettings,
                                    AnnotationTableObject *annotationObj, const QString &aname, const QString &agroup) :
        SmithWatermanSchemaTask(swSettings, annotationObj, aname, agroup), rms(rms_)
    {}

protected:
    virtual RunSchemaForTask* prepareRunSchemaTask()
    {
        return new RemoteRunSchemaForTask(rms, SCHEMA_NAME, schemaParameters, inFile, outFile);
    }

private:
    RemoteMachineSettings *rms;
};    // class SmithWatermanSchemaRemoteTask

}   // namespace U2

#endif    // #ifndef _SMITH_WATERMAN_SCHEMA_TASK_H_
