/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_GRAPHICS_BRANCH_ITEM_H_
#define _U2_GRAPHICS_BRANCH_ITEM_H_

#include <QtGui/QAbstractGraphicsShapeItem>

namespace U2 {

class PhyNode;
class GraphicsButtonItem;

class BranchSettings {
public:
    BranchSettings();

    QColor branchColor;
    int branchThickness;

    static QColor defaultColor;
    static int defaultThickness;
};

class GraphicsBranchItem: public QAbstractGraphicsShapeItem {
public:
    enum Direction { up, down };

    static const int TextSpace;
    static const int SelectedPenWidth;

    BranchSettings settings;

private:
    GraphicsButtonItem* buttonItem;
    void initText(qreal d);

protected:

    QGraphicsSimpleTextItem* distanceText;
    QGraphicsSimpleTextItem* nameText;
    qreal width;
    bool collapsed;

    GraphicsBranchItem(const QString& name);
    GraphicsBranchItem(qreal d, bool withButton = true);


public:
    GraphicsBranchItem(bool withButton = true);

    GraphicsButtonItem* getButton() const { return buttonItem; }
    QGraphicsSimpleTextItem* getDistanceText() const { return distanceText; }
    QGraphicsSimpleTextItem* getNameText() const { return nameText; }
    qreal getWidth() const { return width; }
    void setWidthW(qreal w) { width = w; }
    void setWidth(qreal w);
    virtual void collapse();
    void setSelectedRecurs(bool sel, bool recursively);
    bool isCollapsed();

    void updateSettings(const BranchSettings& branchSettings);
    void updateTextSettings(const QFont& font, const QColor& color);
};

}//namespace;

#endif
