/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _U2_UINDEX_VIEWER_TASKS_H_
#define _U2_UINDEX_VIEWER_TASKS_H_

#include <U2Gui/ObjectViewTasks.h>
#include <U2Core/UIndexObject.h>
#include <U2Core/UnloadedObject.h>

namespace U2 {

class UIndexViewer;

class OpenUIndexViewerTask : public ObjectViewTask {
    Q_OBJECT
public:
    OpenUIndexViewerTask( UIndexObject* indObj );
    OpenUIndexViewerTask( Document* doc );
    OpenUIndexViewerTask( UnloadedObject* obj );
    
    virtual void open();
    
private:
    QPointer< UIndexObject > uindObj;
    GObjectReference         unloadedReference;
    
};

} // U2

#endif // _U2_UINDEX_VIEWER_TASKS_H_
