/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef  _U2_PAN_VIEW_ROWS_H_
#define  _U2_PAN_VIEW_ROWS_H_

#include <U2Core/LRegion.h>

#include <QtCore/QString>
#include <QtCore/QMap>
#include <QtCore/QList>

namespace U2 {

class Annotation;

class PVRowData {
public:
    PVRowData(const QString& _key) : key(_key){}

    bool fitToRow(const QList<LRegion>& locations);

    QString key;
    //invariant: keep the ranges in ascending order
    QList<LRegion> ranges;
    QList<Annotation*> annotations;
};

class PVRowsManager {
public:    
    PVRowsManager() {}
    ~PVRowsManager();
    void clear();

    void addAnnotation(Annotation* f, const QString& key);
    void removeAnnotation(Annotation* f);

    bool contains(const QString& key) const;
    int getNumRows() const {return rows.size();}
    PVRowData* getRow(int row) const;
    int getAnnotationRowIdx(Annotation* a) const;
    PVRowData* getAnnotationRow(Annotation* a) const {return rowByAnnotation.value(a, NULL);}
    
    const QString& getRowKey(int rowNum) const;
    int getNumAnnotationsInRow(int rowNum) const;

private:
    QList<PVRowData*> rows;
    QMap<Annotation*, PVRowData*> rowByAnnotation;
};


} // namespace

#endif
