/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_
#define _U2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_

#include "ui/ui_EditAnnotationDialog.h"

#include <U2Core/LRegion.h>
#include <U2Core/AnnotationTableObject.h>

namespace U2{

class U2VIEW_EXPORT EditAnnotationDialogController : public QDialog, public Ui_EditAnnotationDialog {
    Q_OBJECT
public:
    EditAnnotationDialogController(Annotation* a, LRegion _seqRange, QWidget* p = NULL);

    virtual void accept ();

    QList<LRegion> getRegionList(){return currentRegionList;};
    QString getName(){return currentName;};
    bool isComplement(){return complement;};
    bool isOrder () {return order;}

private slots:
    void sl_onTextChanged(const QString&);
    void sl_setPredefinedAnnotationName();
    void sl_complementLocation();

private:
    QMenu* createAnnotationNamesMenu(QWidget* p, QObject* receiver);

    LRegion seqRange;
    QList<LRegion> currentRegionList;
    QString currentName;
    bool complement;
    bool order;
};

}//ns

#endif //_U2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_
