/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _CREATEPHYTREEDIALOGCONTROLLER_H_
#define _CREATEPHYTREEDIALOGCONTROLLER_H_

#include <U2Core/global.h>
#include <U2Algorithm/CreatePhyTreeSettings.h>

#include <QtGui/QDialog>

class Ui_CreatePhyTree;
class QWidget;

namespace U2{

class MAlignmentObject;
class MAlignment;
class CreatePhyTreeWidget;

class U2VIEW_EXPORT CreatePhyTreeDialogController : public QDialog {
    Q_OBJECT
public:
    CreatePhyTreeDialogController(QWidget* parent, const MAlignmentObject* mobj, CreatePhyTreeSettings& settings);
    ~CreatePhyTreeDialogController();

    void insertWidget(int pos, CreatePhyTreeWidget* widget);

private slots:
    void sl_okClicked();
    void sl_browseClicked();
    
private:
    int rightMargin;
    const MAlignment& msa;
    CreatePhyTreeSettings& settings;
    QList<CreatePhyTreeWidget*> childWidgets;
    Ui_CreatePhyTree* ui;
};

}

#endif