/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "TreeWidgetUtils.h"

namespace U2 {

static void visitBranchDFS(QTreeWidgetItem* item, TreeWidgetVisitor* visitor) {
    if (visitor->isChildVisitRequired(item)) {
        for (int i = 0; i < item->childCount(); i++) {    
            QTreeWidgetItem* child = item->child(i);
            visitBranchDFS(child, visitor);
        }
    }
    visitor->visit(item);
}

void TreeWidgetUtils::visitDFS(QTreeWidget* tree, TreeWidgetVisitor* visitor) {
    for (int i = 0; i < tree->topLevelItemCount(); i++) {
        QTreeWidgetItem* child = tree->topLevelItem(i);
        visitBranchDFS(child, visitor);
    }
}

} //namespace
