/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QMessageBox>

#include <ui/ui_AuthentificationDialog.h>
#include "AuthenticationDialog.h"

namespace U2 {

AuthDialog::AuthDialog( QWidget* parent )
: QDialog(parent)        
{
    ui = new Ui_AuthentificationDialog();
    ui->setupUi(this);
    connect(ui->OKButton, SIGNAL(clicked()), SLOT(sl_onOkButtonClicked()));
}

QString AuthDialog::getUserName() const
{
    return ui->nameEdit->text();
}

QString AuthDialog::getPasswd() const
{
    return ui->passEdit->text();
}

bool AuthDialog::rememberAuthData() const
{
    return ui->rememberBox->isChecked();
}

void AuthDialog::sl_onOkButtonClicked()
{
    if (ui->nameEdit->text().isEmpty() ) {
        QMessageBox::critical( this, tr( "Error!" ), tr("User name is not set.") );
        return; 
    } else  if (ui->passEdit->text().isEmpty()) {
        QMessageBox::critical( this, tr("Error!"), tr("Password is not set.") );
        return; 
    } else {
        accept();
    }
}

AuthDialog::~AuthDialog() 
{
    delete ui;
}

} // namespace
