/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _RUN_SCHEMA_FOR_TASK_H_
#define _RUN_SCHEMA_FOR_TASK_H_

#include <U2Core/Task.h>
#include <U2Lang/Schema.h>
#include <U2Lang/WorkflowIOTasks.h>

namespace U2
{

using namespace Workflow;    // FIXME: decide should it be nested namespace

class CreateSchemaForTask: public Task
{
    Q_OBJECT

public:
    CreateSchemaForTask(const QString schemaName_);

    Schema* getSchema() { return schema; }
    static QString findSchemaFile(const QString &schemaName);

protected:
    virtual void prepare();
    virtual QList<Task*> onSubTaskFinished(Task *subTask);

public:
    static const QString SCHEMAS_DIR;

private:
    Schema *schema;
    QString schemaName;

    LoadWorkflowTask *loadTask;
};    // class CreateSchemaForTask

class U2LANG_EXPORT RunSchemaForTask: public U2::Task
{
    Q_OBJECT

public:
    RunSchemaForTask(const QString &schemaName_, const QVariantMap &schemaParameters_, const QString &inFile_, const QString &outFile_);
    virtual ~RunSchemaForTask();

protected:
    virtual void prepare();
    virtual QList<Task*> onSubTaskFinished(Task *subTask);

    CreateSchemaForTask* prepareCreateSchemaTask();

    // Overload this method to change schema runner task
    virtual Task* prepareWorkflowRunTask();

private:
    // Set schema parameters through CMDLine aliases
    void setSchemaParameters(Schema *schema, const QVariantMap &params);
    void setSchemaParameter(Schema *schema, const QString &param, const QVariant &value);

protected:
    Schema *schema;

private:
    QString schemaName;
    QString inFile, outFile;

    QVariantMap schemaParameters;

    CreateSchemaForTask *createTask;
    Task *runTask;

};    // class RunSchemaForTask

class U2LANG_EXPORT SchemaForTaskUtils
{
public:
    static QString createTempSubDdir(qint64 taskId);
    static void removeTempSubDir(const QString &dirName);
};  // class SchemaForTaskUtils

}    // namespace U2

#endif    // #ifndef _RUN_SCHEMA_FOR_TASK_H_
