/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _U2_WORKFLOW_CORE_LIB_CONSTANTS_H_
#define _U2_WORKFLOW_CORE_LIB_CONSTANTS_H_

#include <QtCore/QObject>

#include <U2Lang/Descriptor.h>

namespace U2 {

namespace Workflow {

class U2LANG_EXPORT CoreLibConstants : public QObject {
    Q_OBJECT
public:
    static const QString WRITE_FASTA_PROTO_ID;
    static const QString READ_TEXT_PROTO_ID;
    static const QString WRITE_TEXT_PROTO_ID;
    static const QString WRITE_GENBANK_PROTO_ID;
    static const QString WRITE_FASTQ_PROTO_ID;

    static const QString GENERIC_READ_MA_PROTO_ID;
    static const QString GENERIC_READ_SEQ_PROTO_ID;

    static const QString WRITE_CLUSTAL_PROTO_ID;

    static const QString WRITE_STOCKHOLM_PROTO_ID;
    
    static const QString WRITE_MSA_PROTO_ID;
    static const QString WRITE_SEQ_PROTO_ID;
    
    static const QString OUT_MSA_PORT_ID;
    static const QString IN_MSA_PORT_ID;
    static const QString OUT_SEQ_PORT_ID;
    static const QString IN_SEQ_PORT_ID;
    static const QString OUT_ANNOTATIONS_PORT_ID;
    static const QString OUT_TEXT_PORT_ID;
    static const QString IN_TEXT_PORT_ID;
    static const Descriptor TEXT_SLOT();
    
    static const QString APPEND_ATTR_ID;
    static const QString DOCUMENT_FORMAT_ATTR_ID;
    static const QString FASTA_HEADER_SLOT_ID;
    static const QString READ_LINES_ID;
    
    static const QString FASTQ_TYPESET_ID;
    static const QString FASTA_TYPESET_ID;
    static const QString SEQ_TYPESET_ID;
    static const QString GENBANK_TYPESET_ID;
    static const QString TEXT_TYPESET_ID;
    static const QString MA_TYPESET_ID;
    
    static const QString WORKFLOW_ON_CLOUD_TASK_ID;
    static const QString WORKFLOW_SCHEMA_ATTR;
    static const QString DATA_IN_ATTR;
    static const QString DATA_OUT_ATTR;

    static const Descriptor URL_IN_ATTR();
    static const Descriptor URL_OUT_ATTR();
    static const Descriptor URL_SLOT();
    static const Descriptor URL_LOCATION_ATTR();
    static const Descriptor WRITE_URL_SLOT();
    
}; // CoreLibConstants

} // Workflow

} // U2

#endif // _U2_WORKFLOW_CORE_LIB_CONSTANTS_H_
