/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CoreLibConstants.h"

static const QString URL_SLOT_ID("url");
static const QString URL_LOCATION_ATTR_ID("url_location");
static const QString URL_OUT_ATTR_ID("url-out");
static const QString URL_IN_ATTR_ID("url-in");
static const QString TEXT_SLOT_ID("text");

namespace U2 {

namespace Workflow {

const QString CoreLibConstants::READ_TEXT_PROTO_ID("read-text");
const QString CoreLibConstants::WRITE_TEXT_PROTO_ID("write-text");

const QString CoreLibConstants::WRITE_FASTA_PROTO_ID("write-fasta");
const QString CoreLibConstants::WRITE_GENBANK_PROTO_ID("write-genbank");
const QString CoreLibConstants::WRITE_CLUSTAL_PROTO_ID("write-clustalw");
const QString CoreLibConstants::WRITE_STOCKHOLM_PROTO_ID("write-stockholm");
const QString CoreLibConstants::WRITE_MSA_PROTO_ID("write-msa");
const QString CoreLibConstants::WRITE_SEQ_PROTO_ID("write-sequence");
const QString CoreLibConstants::WRITE_FASTQ_PROTO_ID("write-fastq");

const QString CoreLibConstants::GENERIC_READ_MA_PROTO_ID("read-msa");
const QString CoreLibConstants::GENERIC_READ_SEQ_PROTO_ID("read-sequence");

const QString CoreLibConstants::APPEND_ATTR_ID("accumulate");
const QString CoreLibConstants::DOCUMENT_FORMAT_ATTR_ID("document-format");
const QString CoreLibConstants::READ_LINES_ID("read-by-lines");

const QString CoreLibConstants::OUT_MSA_PORT_ID("out-msa");
const QString CoreLibConstants::IN_MSA_PORT_ID("in-msa");
const QString CoreLibConstants::OUT_SEQ_PORT_ID("out-sequence");
const QString CoreLibConstants::IN_SEQ_PORT_ID("in-sequence");
const QString CoreLibConstants::OUT_ANNOTATIONS_PORT_ID("out-annotations");
const QString CoreLibConstants::OUT_TEXT_PORT_ID("out-text");
const QString CoreLibConstants::IN_TEXT_PORT_ID("in-text");

const Descriptor CoreLibConstants::TEXT_SLOT() {
    return Descriptor(TEXT_SLOT_ID, tr("Plain text"), tr("Plain text reading or splitting to strings."));
}

const QString CoreLibConstants::FASTA_HEADER_SLOT_ID("fasta-header");

const Descriptor CoreLibConstants::URL_IN_ATTR() {
    return Descriptor(URL_IN_ATTR_ID, tr("Input files"), tr("Semicolon-separated list of paths to the input files."));
}

const Descriptor CoreLibConstants::URL_OUT_ATTR() {
    return Descriptor(URL_OUT_ATTR_ID, tr("Output file"), tr("Location of output data file. If this attribute is set," 
                                                             " slot \"Location\" in port will not be used"));
}

const Descriptor CoreLibConstants::URL_SLOT() {
    return Descriptor(URL_SLOT_ID, tr("Source URL"), tr("Location of a corresponding input file."));
}

const Descriptor CoreLibConstants::URL_LOCATION_ATTR() {
    return Descriptor(URL_LOCATION_ATTR_ID, tr("Located on"), tr("Machine file(s) are located on")); 
}

const QString CoreLibConstants::GENBANK_TYPESET_ID("genbank.content");
const QString CoreLibConstants::FASTA_TYPESET_ID("fasta.content");
const QString CoreLibConstants::FASTQ_TYPESET_ID("fastq.content");
const QString CoreLibConstants::SEQ_TYPESET_ID("seq.content");
const QString CoreLibConstants::TEXT_TYPESET_ID("text.content");
const QString CoreLibConstants::MA_TYPESET_ID("ma.content");

const QString CoreLibConstants::WORKFLOW_ON_CLOUD_TASK_ID("cloud.workflow");
const QString CoreLibConstants::WORKFLOW_SCHEMA_ATTR("workflow.shema");
const QString CoreLibConstants::DATA_IN_ATTR("data.in");
const QString CoreLibConstants::DATA_OUT_ATTR("data.out");

} // Workflow

} // U2
