/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "QueryDesignerRegistry.h"


namespace U2 {

void QDActorPrototypeRegistry::registerProto(QDActorPrototype* _factory) {
    IdRegistry<QDActorPrototype>::registerEntry(_factory);
    emit si_registryModified();
}

QDActorPrototype* QDActorPrototypeRegistry::unregisterProto(const QString& id) {
    QDActorPrototype* removed = IdRegistry<QDActorPrototype>::unregisterEntry(id);
    if(removed) {
        emit si_registryModified();
    }
    return removed;
}

}//namespace
