/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include"SeqPasterWidgetController.h"
#include "ui/ui_SeqPasterWidget.h"

#include <U2Core/AppContext.h>
#include <U2Core/DNAAlphabet.h>

namespace U2{

SeqPasterWidgetController::SeqPasterWidgetController( QWidget *p, const QByteArray& initText ): 
QWidget(p), preferred(0) 
{
    ui = new Ui_SeqPasterWidget;
    //TODO: add not null project checking
    ui->setupUi(this);
    if (!initText.isEmpty()) {
        ui->sequenceEdit->setPlainText(initText);
    }

    QList<DNAAlphabet*> alps = AppContext::getDNAAlphabetRegistry()->getRegisteredAlphabets();
    foreach(DNAAlphabet *a, alps){
        ui->alphabetBox->addItem(a->getName(), a->getId());
    }
    connect(ui->alphabetBox, SIGNAL(currentIndexChanged(const QString&)), SLOT(sl_currentindexChanged(const QString&)));
}

QByteArray SeqPasterWidgetController::getNormSequence(DNAAlphabet * alph, const QByteArray & seq, bool replace, QChar replaceChar) {
    assert(alph != NULL);
    QByteArray ret;
    if(alph->getId() == BaseDNAAlphabetIds::RAW()){
        foreach(QChar c, seq){
            QChar::Category cat = c.category();
            if((cat != QChar::Separator_Space) &&
                (cat != QChar::Other_Control)){
                    ret.append(c);
            }
        }
    }else{
        QByteArray alphabetSymbols = alph->getAlphabetChars(true);
        for(int i = 0; i < seq.size(); i++){
            QChar c = seq.at(i);
            if(alphabetSymbols.indexOf(c) > -1){
                ret.append(c);
            }else{
                if (replace){
                    ret.append(replaceChar);
                }
            }
        }
    }
    return ret;
}

QString SeqPasterWidgetController::validate(){
    if(ui->sequenceEdit->toPlainText().isEmpty()){
        return tr("Input sequence is empty");
    }
    bool replace = ui->replaceRB->isChecked();
    if(replace && ui->symbolToReplaceEdit->text().isEmpty()) {
        return tr("Replace symbol is empty");
    }
    
    QByteArray seq = ((ui->sequenceEdit->document())->toPlainText()).toUtf8();
    DNAAlphabetRegistry *r = AppContext::getDNAAlphabetRegistry();
    DNAAlphabet *alph = NULL;
    if(ui->useCustomSettingsBox->isChecked()){
        alph = r->findById((ui->alphabetBox->itemData(ui->alphabetBox->currentIndex())).toString());
    }else{
        if(preferred != NULL){
            alph = preferred;
        }else{
            alph = r->findAlphabet(seq);
        }
    }
    if(alph == NULL){
        return tr("Alphabet not detected");
    }
    QChar replaceChar = replace ? ui->symbolToReplaceEdit->text().at(0) : QChar();
    QByteArray normSequence = getNormSequence(alph, seq, replace, replaceChar);
    resultSeq = DNASequence("New Sequence", normSequence, alph);
    return QString();
}

void SeqPasterWidgetController::sl_currentindexChanged( const QString& newText){
    DNAAlphabetRegistry *r = AppContext::getDNAAlphabetRegistry();
    if((r->findById(BaseDNAAlphabetIds::RAW()))->getName() == newText){
        ui->skipRB->setDisabled(true);
        ui->replaceRB->setDisabled(true);
        ui->symbolToReplaceEdit->setDisabled(true);
    }else{
        ui->skipRB->setEnabled(true);
        ui->replaceRB->setEnabled(true);
        ui->symbolToReplaceEdit->setEnabled(true);
    }
}

void SeqPasterWidgetController::disableCustomSettings(){
    ui->useCustomSettingsBox->setChecked(false);
    ui->useCustomSettingsBox->setDisabled(true);
	ui->useCustomSettingsBox->hide();
	ui->groupBox->hide();
}

void SeqPasterWidgetController::setPreferredAlphabet( DNAAlphabet *alp ){
    preferred = alp;
}

SeqPasterWidgetController::~SeqPasterWidgetController()
{
    delete ui;
}

}//ns
