/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REMOVE_PART_FROM_SEQUENCE_CONTROLLER_H_
#define _U2_REMOVE_PART_FROM_SEQUENCE_CONTROLLER_H_

#include <U2Misc/DialogUtils.h>
#include <U2Core/LRegion.h>
#include <U2Core/RemovePartFromSequenceTask.h>

#include <QtGui/QDialog>

class Ui_RemovePartFromSequenceDialog;

namespace U2{

class U2GUI_EXPORT RemovePartFromSequenceDialogController : public QDialog {
    Q_OBJECT
public:
    RemovePartFromSequenceDialogController(LRegion _toDelete, LRegion _source, const QString & docUrl, QWidget *p = NULL);
    ~RemovePartFromSequenceDialogController();
    virtual void accept();

    bool modifyCurrentDocument() const;;
    QString getNewDocumentPath() const;;
    AnnotationUtils::AnnotationStrategyForResize getStrategy();
    LRegion getRegionToDelete() const {return toDelete;};
    bool mergeAnnotations() const;;
    DocumentFormatId getDocumentFormatId() const;;

private slots:
    void sl_browseButtonClicked();
    void sl_indexChanged(int);
    void sl_mergeAnnotationsToggled(bool);

private:
    QString filter;
    LRegion toDelete;
    LRegion source;
    Ui_RemovePartFromSequenceDialog* ui;
};

}//ns

#endif

