/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_EDIT_QUALIFIER_DIALOG_H_
#define _U2_EDIT_QUALIFIER_DIALOG_H_

#include <U2Core/global.h>
#include <U2Core/AnnotationTableObject.h>

#include <QtGui/QDialog>

class Ui_EditQualifierDialog;

namespace U2 {

class U2GUI_EXPORT EditQualifierDialog: public QDialog {
    Q_OBJECT
public:
    EditQualifierDialog(QWidget* p, const Qualifier& q, bool ro, bool existingQualifier );
    ~EditQualifierDialog();
    
    virtual void accept();
    
    const Qualifier& getModifiedQualifier() const {return q;}

protected:
    bool eventFilter(QObject *obj, QEvent *e);

private:
    Qualifier q;
    Ui_EditQualifierDialog* ui;
    
};

}//namespace
#endif
