/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_REPLACE_PART_OF_SEQUENCE_TASK_H_
#define _U2_REPLACE_PART_OF_SEQUENCE_TASK_H_

#include <U2Core/Task.h>
#include <U2Core/DocumentModel.h>
#include <U2Core/DNASequenceObject.h>
#include <U2Core/AnnotationUtils.h>

namespace U2 {

class Annotation;

class U2CORE_EXPORT ReplacePartOfSequenceTask : public Task {
    Q_OBJECT
public:
    ReplacePartOfSequenceTask(DocumentFormatId _dfId, DNASequenceObject *_seqObj, LRegion _regionToReplace, const DNASequence& newSeq, 
        AnnotationUtils::AnnotationStrategyForResize _str = AnnotationUtils::AnnotationStrategyForResize_Resize, 
        const GUrl& _url = GUrl(), bool _mergeAnnotations = false);
    virtual Task::ReportResult report();

private:
    void fixAnnotations();
    void preparationForSave();
    
    DocumentFormatId dfId;
    bool mergeAnnotations;
    Document *curDoc;
    Document *newDoc;
    bool save;
    GUrl url;
    AnnotationUtils::AnnotationStrategyForResize strat;
    QList<Document*> docs;
    DNASequenceObject *seqObj;
    QByteArray newSeq;
    LRegion regionToReplace;
};

} // U2

#endif //_U2_REPLACE_PART_OF_SEQUENCE_TASK_H_
