/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DocumentFormatConfigurators.h"

namespace U2 {

DocumentFormatConfigurators::~DocumentFormatConfigurators() {
    foreach(DocumentFormatConfigurator* c, configs.values()) {
        delete c;
    }
    configs.clear();
}


void DocumentFormatConfigurators::registerConfigurator(DocumentFormatConfigurator* c) {
    assert(!configs.contains(c->getFormatId()));
    configs[c->getFormatId()] = c;
}

void DocumentFormatConfigurators::unregisterConfigurator(const DocumentFormatId& id) {
    DocumentFormatConfigurator* c = configs.value(id);
    assert(c!=NULL);
    configs.remove(id);
    delete c;
}

DocumentFormatConfigurator* DocumentFormatConfigurators::findConfigurator(const DocumentFormatId& id) const {
    DocumentFormatConfigurator* c = configs.value(id);
    return c;
}


} //namespace
