/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "DataBaseRegistry.h"

namespace U2 {

DataBaseRegistry::DataBaseRegistry(QObject *o):QObject(o) {
}

DataBaseRegistry::~DataBaseRegistry() {
    foreach(const DataBaseFactory *dbf, factories) {
        delete dbf;
    }
}

bool DataBaseRegistry::registerDataBase(DataBaseFactory *f, const QString &id) {
    if(!isRegistered(id)) {
        factories[id] = f;
        return true;
    }
    else {
        return false;
    }
}

bool DataBaseRegistry::isRegistered(const QString& id) {
    if(factories.contains(id)) {
        return true;
    }
    else {
        return false;
    }
}

DataBaseFactory *DataBaseRegistry::getFactoryById(const QString &id) {
    if(isRegistered(id)) {
        return factories[id];
    }
    else {
        return NULL;
    }
}

}