/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_MALIGNMENT_INFO_H_
#define _U2_MALIGNMENT_INFO_H_

#include <QtCore/QString>

#include <U2Core/global.h>

namespace U2 {

class U2CORE_EXPORT MAlignmentInfo {
public:
    static const QString NAME;
    static const QString ACCESSION;
    static const QString DESCRIPTION;
    static const QString SS_CONSENSUS;          /* Secondary structure consensus */
    static const QString REFERENCE_LINE;        /* #=GC RF annotation in Stockholm markup */
    static const QString CUTOFFS;               /* #=GF GA, NC, TC annotation in Stockholm markup */
                                                  
    enum Cutoffs { /* Should be same as in esl_msa.h( uhmmer plugin ) */
        CUTOFF_TC1,
        CUTOFF_TC2,
        CUTOFF_GA1,
        CUTOFF_GA2,
        CUTOFF_NC1,
        CUTOFF_NC2
    };
    
    static bool     isValid( const QVariantMap& map ); /* Checks obligatory fields in info */
    
    static QString  getName( const QVariantMap& map );
    static void     setName( QVariantMap& map, const QString& name );
    static bool     hasName( const QVariantMap& map );
    
    static QString  getAccession( const QVariantMap& map ); 
    static void     setAccession( QVariantMap& map, const QString& acc );
    static bool     hasAccession( const QVariantMap& map );
    
    static QString  getDescription( const QVariantMap& map );
    static void     setDescription( QVariantMap& map, const QString& desc );
    static bool     hasDescription( const QVariantMap& map );
    
    static QString  getSSConsensus( const QVariantMap& map );
    static void     setSSConsensus( QVariantMap& map, const QString& cs );
    static bool     hasSSConsensus( const QVariantMap& map );
    
    static QString  getReferenceLine( const QVariantMap& map );
    static void     setReferenceLine( QVariantMap& map ,const QString& rf );
    static bool     hasReferenceLine( const QVariantMap& map );
    
    static float    getCutoff( const QVariantMap& map, Cutoffs coff );
    static bool     hasCutoff( const QVariantMap& map, Cutoffs coff );
    static void     setCutoff( QVariantMap& map, Cutoffs coff, float val );
    
}; // MAlignmentInfo

} // U2

#endif // _U2_MALIGNMENT_INFO_H_
