/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_DNA_CHROMATOGRAM_H_
#define _U2_DNA_CHROMATOGRAM_H_

#include <QtCore/QVector>
#include <U2Core/global.h>

namespace U2 {

class U2CORE_EXPORT DNAChromatogram {
public:
    DNAChromatogram() : traceLength(0), seqLength(0), hasQV(false) {}
    int traceLength;
    int seqLength;
    QVector<ushort> baseCalls;
    QVector<ushort> A;
    QVector<ushort> C;
    QVector<ushort> G;
    QVector<ushort> T;
    QVector<char> prob_A;
    QVector<char> prob_C;
    QVector<char> prob_G;
    QVector<char> prob_T;
    bool hasQV;
};

} //namespace

#endif
