/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_CREATE_SUBALIGNMENT_TASK_H_
#define _U2_CREATE_SUBALIGNMENT_TASK_H_

#include <U2Core/Task.h>
#include <U2Core/GUrl.h>
#include <U2Core/LRegion.h>
#include <U2Core/MAlignmentObject.h>



namespace U2{

class U2ALGORITHM_EXPORT CreateSubalignmentTask : public Task {
    Q_OBJECT
public:    
    CreateSubalignmentTask(MAlignmentObject* _maObj, LRegion _window, 
                            const QStringList& _seqNames, const GUrl& _url, 
                            bool saveImmediately = false );

    ~CreateSubalignmentTask(){};

    void prepare();
    Task::ReportResult report();

signals:
    void documentCreated(Document *);

private:
    bool                saveToAnother;
    Document *          curDoc;
    MAlignmentObject*   maObj;
    LRegion             window;
    QStringList         seqNames;
    GUrl                url;
    Document*           newDoc;
    bool                saveImmediately;
};

}

#endif
