/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_MSA_DISTANCE_ALGORITHM_H_
#define _U2_MSA_DISTANCE_ALGORITHM_H_

#include <U2Core/global.h>
#include <U2Core/LRegion.h>
#include <U2Core/Task.h>
#include <U2Core/MAlignment.h>
#include <QtCore/QVarLengthArray>
#include <QtCore/QMutex>

namespace U2 {

class MAlignment;
class MSADistanceAlgorithm;
class DNAAlphabet;

enum DistanceAlgorithmFlag {
    DistanceAlgorithmFlag_Nucleic = 1 << 0,
    DistanceAlgorithmFlag_Amino = 1 << 1,
    DistanceAlgorithmFlag_Raw = 1 << 2,
};

typedef QFlags<DistanceAlgorithmFlag> DistanceAlgorithmFlags;
#define DistanceAlgorithmFlags_AllAlphabets (DistanceAlgorithmFlags(DistanceAlgorithmFlag_Nucleic) | DistanceAlgorithmFlag_Amino | DistanceAlgorithmFlag_Raw)
#define DistanceAlgorithmFlags_NuclAmino    (DistanceAlgorithmFlags(DistanceAlgorithmFlag_Nucleic) | DistanceAlgorithmFlag_Amino)

class U2ALGORITHM_EXPORT MSADistanceAlgorithmFactory : public QObject {
    Q_OBJECT
public:
    MSADistanceAlgorithmFactory(const QString& algoId, DistanceAlgorithmFlags flags, QObject* p = NULL);
    
    virtual MSADistanceAlgorithm* createAlgorithm(const MAlignment& ma, QObject* parent = NULL) = 0;
    
    QString getId() const {return algorithmId;}

    DistanceAlgorithmFlags getFlags() const {return flags;}

    virtual QString getDescription() const = 0;

    virtual QString getName() const = 0;

    // utility method
    static DistanceAlgorithmFlags getAphabetFlags(const DNAAlphabet* al);

private:
    QString                 algorithmId;
    DistanceAlgorithmFlags  flags;

};

class U2ALGORITHM_EXPORT MSADistanceAlgorithm : public Task {
    Q_OBJECT
public:
    MSADistanceAlgorithm(MSADistanceAlgorithmFactory* factory, const MAlignment& ma);

    int getSimilarity(int row1, int row2);
    
    virtual QString getDescription() const {return factory->getDescription();}

    virtual QString getName() const {return factory->getName();}

    QString getId() const {return factory->getId();}

    MSADistanceAlgorithmFactory* getFactory() const {return factory;}

private:
    MSADistanceAlgorithmFactory*    factory;

protected:
    MAlignment                                  ma;
    QVarLengthArray<QVarLengthArray<int> >      distanceTable;
    QMutex                                      lock;
};

}//namespace

#endif
