/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _U2_SW_RESULT_FILTER_REGISTRY_H_
#define _U2_SW_RESULT_FILTER_REGISTRY_H_

#include <QtCore/QStringList>
#include <QtCore/QMutex>

#include <U2Algorithm/SmithWatermanResultFilters.h>


namespace U2 {

class U2ALGORITHM_EXPORT SWResultFilterRegistry: public QObject {
    Q_OBJECT
public:
    SWResultFilterRegistry(QObject* pOwn = 0);
    ~SWResultFilterRegistry();
    
    QStringList getFiltersIds() const;
    
    SmithWatermanResultFilter* getFilter(const QString& id);
    
    bool isRegistered(const QString& id) const;
    
    bool registerFilter( SmithWatermanResultFilter* filter );

    const QString& getDefaultFilterId() {return defaultFilterId;}

private:
    QMutex mutex;
    QHash<QString, SmithWatermanResultFilter*> filters;   
    QString defaultFilterId;
};

} // namespace

#endif
