/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_USER_APP_SETTINGS_GUI_CONTROLLER_H_
#define _GB2_USER_APP_SETTINGS_GUI_CONTROLLER_H_

#include <ui/ui_UserApplicationsSettingsWidget.h>

#include <core_api/NetworkConfiguration.h>
#include <core_api/AppSettingsGUI.h>

#include <QtCore/QUrl>

namespace GB2 {


class UserApplicationsSettingsPageController : public AppSettingsGUIPageController {
    Q_OBJECT
public:
    UserApplicationsSettingsPageController(QObject* p = NULL);

    virtual AppSettingsGUIPageState* getSavedState();

    virtual void saveState(AppSettingsGUIPageState* s);

    virtual AppSettingsGUIPageWidget* createWidget(AppSettingsGUIPageState* data);
    
    QMap<QString, QString> translations;
};


class UserApplicationsSettingsPageState : public AppSettingsGUIPageState {
    Q_OBJECT
public:
    UserApplicationsSettingsPageState(){}
    QString webBrowserUrl;
    QString translFile;
    QString style;
    QString downloadsDirPath;
    bool useDefaultWebBrowser;
    bool openLastProjectFlag;
    bool enableStatistics;
};


class UserApplicationsSettingsPageWidget: public AppSettingsGUIPageWidget, public Ui_UserApplicationsSettingsWidget {
    Q_OBJECT
public:
    UserApplicationsSettingsPageWidget(UserApplicationsSettingsPageController* ctrl);

    virtual void setState(AppSettingsGUIPageState* state);

    virtual AppSettingsGUIPageState* getState(QString& err) const;

private slots:
    void sl_wbURLClicked();
    void sl_transFileClicked();
    void sl_browseButtonClicked();
};

}//namespace

#endif
