/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "myutils.h"
//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>
#include "Muscle4TaskLocalStorage.h"

bool IsEmitState(char c, bool First)
	{
	if (c == 'M')
		return true;
	if (First)
		return c == 'D';
	else
		return c == 'I';
	}

byte *MakeGappedSeq(const byte *A, const string &Path, bool First)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context(); 
	unsigned i = 0;
	const unsigned ColCount = SIZE(Path);
	byte *sA = myalloc<byte>(ColCount+1); //MEMORY LEAK
	ctx->leaked_pointers.push_back(sA); //MEMORY
	for (unsigned ColIndex = 0; ColIndex < ColCount; ++ColIndex)
		{
		char c = Path[ColIndex];
		if (IsEmitState(c, First))
			{
			char a = A[i++];
			sA[ColIndex] = a;
			}
		else
			sA[ColIndex] = '-';
		}
	sA[ColCount]='\0';
	return sA;
	}

// LoPos is lo offset of aligned region in non-rev-comp'd sequence.
byte *MakeGappedSeqRevComp(const byte *A, unsigned LoPos, const string &Path,
  bool First)
	{
	const unsigned ColCount = SIZE(Path);
	byte *sA = myalloc<byte>(ColCount);
	unsigned N = 0;
	for (unsigned ColIndex = 0; ColIndex < ColCount; ++ColIndex)
		{
		char c = Path[ColIndex];
		if (IsEmitState(c, First))
			++N;
		}
	unsigned i = LoPos + N -1;
	for (unsigned ColIndex = 0; ColIndex < ColCount; ++ColIndex)
		{
		char c = Path[ColIndex];
		if (IsEmitState(c, First))
			{
			byte CompLetter(byte c);

			char a = A[i--];
			sA[ColIndex] = CompLetter(a);
			}
		else
			sA[ColIndex] = '-';
		}
	return sA;
	}

byte *MakeGappedSeq2(const byte *A, unsigned LoPos, const string &Path,
  bool First, bool Plus)
	{
	GB2::Muscle4Context *ctx = getMuscle4Context(); 
	if (!Plus)
		return MakeGappedSeqRevComp(A, LoPos, Path, First);

	unsigned i = LoPos;
	const unsigned ColCount = SIZE(Path);
	byte *sA = myalloc<byte>(ColCount+1);
	ctx->leaked_pointers.push_back(sA); //MEMORY
	for (unsigned ColIndex = 0; ColIndex < ColCount; ++ColIndex)
		{
		char c = Path[ColIndex];
		if (IsEmitState(c, First))
			{
			char a = A[i++];
			sA[ColIndex] = a;
			}
		else
			sA[ColIndex] = '-';
		}
	sA[ColCount]='\0';
	return sA;
	}
