/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _UMUSCLE4_TASK_LOCAL_STORAGE_
#define _UMUSCLE4_TASK_LOCAL_STORAGE_

#include <QtCore/QThreadStorage>
#include "Muscle4Context.h"

GB2::Muscle4Context *getMuscle4Context();
GB2::MatrixContainer *getMatrixContainer();

namespace GB2 {

class Muscle4ContextTLSRef {
public:
    Muscle4ContextTLSRef(Muscle4Context* _ctx, int _workerID) : ctx(_ctx), workerID(_workerID){}
    Muscle4Context* ctx;
    int workerID;
};

class MatrixContainerRef {
public:
    MatrixContainerRef(MatrixContainer* _mtx, int _workerID) : mtx(_mtx), workerID(_workerID){}
	MatrixContainer* mtx;
    int workerID;
};


class Muscle4TaskLocalData {
public:
    static Muscle4Context* current();
	static MatrixContainer* matrixContainer();
    static unsigned currentWorkerID();


    static void bindContext(Muscle4Context *ctx, int workerID = 0);
	static void bindContainer(MatrixContainer *mtx, int workerID = 0);

    static void detachContext();
	static void detachMatrix();


private:
	static QThreadStorage<MatrixContainerRef*> matrixStorage;
    static QThreadStorage<Muscle4ContextTLSRef*> contextStorage;
	
};
} //namespace

#endif