/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Muscle4Plugin.h"
#include "Muscle4Task.h"
#include "Muscle4Tests.h"
#include "Muscle4Worker.h"

#include <core_api/AppContext.h>
#include <core_api/Task.h>
#include <core_api/Log.h>
#include <util_ov_msaedit/MSAEditor.h>
#include <util_ov_msaedit/MSAEditorFactory.h>
#include <gobjects/MAlignmentObject.h>
#include <gobjects/GObjectTypes.h>

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_gui/DialogUtils.h>

#include <test_framework/xmltest/XMLTestFormat.h>
#include <test_framework/GTest.h>
#include <test_framework/GTestFrameworkComponents.h>
#include <test_framework/xmltest/DocumentModelTests.h>

#include <QtGui/QDialog>
#include <QtGui/QFileDialog>

//#define _CRTDBG_MAP_ALLOC
//#include <crtdbg.h>
//#include <stdlib.h>

#define ULOG_CAT_MUSCLE "Plugin: MUSCLE 4"

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    Muscle4Plugin * plug = new Muscle4Plugin();
    return plug;
}

LogCategory log(ULOG_CAT_MUSCLE);

    
Muscle4Plugin::Muscle4Plugin() 
: Plugin(tr("MUSCLE 4 "), 
         tr("A preview for MUSCLE 4 algorithm for multiple sequence alignment. Check http://www.drive5.com/muscle/ for the original version")),
         ctx(NULL)
{
    if (AppContext::getMainWindow()) {
        ctx = new Muscle4MSAEditorContext(this);
        ctx->init();
    }
    LocalWorkflow::Muscle4WorkerFactory::init();
    //uMUSCLE Test
    GTestFormatRegistry* tfr = AppContext::getTestFramework()->getTestFormatRegistry();
    XMLTestFormat *xmlTestFormat = qobject_cast<XMLTestFormat*>(tfr->findFormat("XML"));
    assert(xmlTestFormat!=NULL);

    GAutoDeleteList<XMLTestFactory>* l = new GAutoDeleteList<XMLTestFactory>(this);
    l->qlist = Muscle4Tests::createTestFactories();

    foreach(XMLTestFactory* f, l->qlist) { 
        bool res = xmlTestFormat->registerTestFactory(f);
        Q_UNUSED(res);
        assert(res);
    }
}

Muscle4Plugin::~Muscle4Plugin() {
    //nothing to do
}

MSAEditor* Muscle4Action::getMSAEditor() const {
    MSAEditor* e = qobject_cast<MSAEditor*>(getObjectView());
    assert(e!=NULL);
    return e;
}

void Muscle4Action::sl_lockedStateChanged() {
    StateLockableItem* item = qobject_cast<StateLockableItem*>(sender());
    assert(item!=NULL);
    setEnabled(!item->isStateLocked());
}

Muscle4MSAEditorContext::Muscle4MSAEditorContext(QObject* p) : GObjectViewWindowContext(p, MSAEditorFactory::ID) {
}


void Muscle4MSAEditorContext::initViewContext(GObjectView* view) {
    MSAEditor* msaed = qobject_cast<MSAEditor*>(view);
    assert(msaed!=NULL);

    bool objLocked = msaed->getMSAObject()->isStateLocked();
    Muscle4Action* alignAction = new Muscle4Action(this, view, tr("Align with MUSCLE 4 (preview)"));
    alignAction->setIcon(QIcon(":umuscle/images/muscle_16.png"));
    alignAction->setEnabled(!objLocked);
    connect(alignAction, SIGNAL(triggered()), SLOT(sl_align()));
    connect(msaed->getMSAObject(), SIGNAL(si_lockedStateChanged()), alignAction, SLOT(sl_lockedStateChanged()));
    addViewAction(alignAction);
}

void Muscle4MSAEditorContext::buildMenu(GObjectView* v, QMenu* m) {
    QList<GObjectViewAction *> actions = getViewActions(v);
    QMenu* alignMenu = GUIUtils::findSubMenu(m, MSAE_MENU_ALIGN);
    assert(alignMenu!=NULL);
    foreach(GObjectViewAction* a, actions) {
        alignMenu->addAction(a);
    }    
}

void Muscle4MSAEditorContext::sl_align() {
    Muscle4Action* action = qobject_cast<Muscle4Action*>(sender());
    assert(action!=NULL);
    MSAEditor* ed = action->getMSAEditor();
    MAlignmentObject* obj = ed->getMSAObject(); 
    assert(!obj->isStateLocked());
    Muscle4TaskSettings s;
    Muscle4GObjectTask* t = new Muscle4GObjectTask(obj, s);
    AppContext::getTaskScheduler()->registerTopLevelTask(t);
}

void Muscle4MSAEditorContext::sl_alignSequencesToProfile() {
   
}

void Muscle4MSAEditorContext::sl_alignProfileToProfile() {
}

}//namespace
