/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE_WORKER_H_
#define _GB2_MUSCLE_WORKER_H_

#include <workflow_library/LocalDomain.h>
#include <workflow_support/WorkflowUtils.h>
#include "MuscleTask.h"

namespace GB2 {

namespace LocalWorkflow {

class MusclePrompter : public PrompterBase<MusclePrompter> {
    Q_OBJECT
public:
    MusclePrompter(Actor* p = 0) : PrompterBase<MusclePrompter>(p) {}
protected:
    QString composeRichDoc();
};

class MuscleWorker : public BaseWorker {
    Q_OBJECT
public:
    MuscleWorker(Actor* a) : BaseWorker(a), input(NULL), output(NULL) {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() {}
private slots:
    void sl_taskFinished();

protected:
    CommunicationChannel *input, *output;
    QString resultName,transId;
    MuscleTaskSettings cfg;
}; 

class MuscleWorkerFactory : public DomainFactory {
public:
    static const QString ACTOR_ID;
    static void init();
    MuscleWorkerFactory() : DomainFactory(ACTOR_ID) {}
    virtual Worker* createWorker(Actor* a) {return new MuscleWorker(a);}
};

}//Workflow namespace
}//GB2 namespace

#endif
