/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MUSCLE_TASK_H_
#define _GB2_MUSCLE_TASK_H_

#include <core_api/Task.h>
#include <gobjects/MAlignmentObject.h>

#include <QtCore/QPointer>

class MuscleContext;

namespace GB2 {

class StateLock;
class MAlignmentObject;
class LoadDocumentTask;
class MuscleParallelTask;

enum MuscleTaskOp {
    MuscleTaskOp_Align,
    MuscleTaskOp_Refine,
    MuscleTaskOp_AddUnalignedToProfile,
    MuscleTaskOp_ProfileToProfile
};

class MuscleTaskSettings {
public:
    MuscleTaskSettings() {reset();}
    void reset();

    MuscleTaskOp    op;

    int             maxIterations;
    unsigned long   maxSecs; // 0 - unlimited
    bool            stableMode;

    //used only for MuscleTaskOp_DoAlign
    bool            alignRegion;
    LRegion         regionToAlign;

    //used only for MuscleTaskOp_AddUnalignedToProfile and MuscleTaskOp_ProfileToProfile
    MAlignment      profile;

    //number of threads: 0 - auto, 1 - serial
    int nThreads;

};

class MuscleTask : public Task {
    Q_OBJECT
public:
    MuscleTask(const MAlignment& ma, const MuscleTaskSettings& config);

    void run();

    void doAlign(bool refineOnlyMode);
    void doAddUnalignedToProfile();
    void doProfile2Profile();

    ReportResult report();

    MuscleTaskSettings          config;
    MAlignment                  inputMA;
    MAlignment                  resultMA;

    MAlignment                  inputSubMA;
    MAlignment                  resultSubMA;

    MuscleContext*              ctx;
    MuscleParallelTask*         parallelSubTask;
};

class MuscleAddSequencesToProfileTask : public Task {
    Q_OBJECT
public:
    enum MMode {Profile2Profile, Sequences2Profile};
    MuscleAddSequencesToProfileTask(MAlignmentObject* obj, const QString& fileWithSequencesOrProfile, MMode mode);

    QList<Task*> onSubTaskFinished(Task* subTask);

    ReportResult report();

    QPointer<MAlignmentObject>  maObj;
    LoadDocumentTask*           loadTask;
    MMode                       mode;
};

//locks MAlignment object and propagate MuscleTask results to it
class  MuscleGObjectTask : public Task {
    Q_OBJECT
public:
    MuscleGObjectTask(MAlignmentObject* obj, const MuscleTaskSettings& config);
    ~MuscleGObjectTask();

    virtual void prepare();
    ReportResult report();

    QPointer<MAlignmentObject>  obj;
    StateLock*                  lock;
    MuscleTask*                 muscleTask;
    MuscleTaskSettings          config;
};
}//namespace
#endif
