/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UHMMER_PHMMER_TASK_H_
#define _GB2_UHMMER_PHMMER_TASK_H_

#include <QtCore/QList>
#include <QtCore/QMutex>

#include <core_api/Task.h>
#include <gobjects/AnnotationTableObject.h>
#include <datatype/DNASequence.h>
#include <util_tasks/LoadDocumentTask.h>
#include <util_tasks/CreateAnnotationTask.h>

#include "uhmm3phmmer.h"

namespace GB2 {

/**************************************
* General hmmer3 phmmer task.
**************************************/

class UHMM3PhmmerTask : public Task {
    Q_OBJECT
public:
    UHMM3PhmmerTask( const DNASequence & query, const DNASequence & db, const UHMM3PhmmerSettings & settings );
    UHMM3PhmmerTask( const QString & queryFilename, const QString & dbFilename, const UHMM3PhmmerSettings & settings );
    UHMM3PhmmerTask( const QString & queryFilename, const DNASequence & db, const UHMM3PhmmerSettings & settings );
    
    void run();
    
    QList< Task* > onSubTaskFinished( Task* subTask );
    
    UHMM3SearchResult getResult() const;
    QList< SharedAnnotationData > getResultsAsAnnotations( const QString & name ) const;
    
private:
    DNASequence getSequenceFromDocument( Document * doc );
    
private:
    DNASequence         query;
    DNASequence         db;
    UHMM3SearchResult   result;
    UHMM3PhmmerSettings settings;
    
    LoadDocumentTask *  loadQueryTask;
    LoadDocumentTask *  loadDbTask;
    QMutex              loadTasksMtx;
    
}; // UHMM3PhmmerTask

/*******************************************
* HMMER3 phmmer search to annotations task.
********************************************/

class UHMM3PhmmerToAnnotationsTask : public Task {
    Q_OBJECT
public:
    UHMM3PhmmerToAnnotationsTask( const QString & querySeqfile, const DNASequence & dbSeq, AnnotationTableObject * obj,
        const QString & group, const QString & name, const UHMM3PhmmerSettings & setings );
    
    QList< Task* > onSubTaskFinished( Task * subTask );
    
    QString generateReport() const;
    
private:
    void checkArgs();
    
private:
    QString                             queryfile;
    DNASequence                         dbSeq;
    QString                             annGroup;
    QString                             annName;
    UHMM3PhmmerSettings                 settings;
    QPointer< AnnotationTableObject >   annotationObj;
    UHMM3PhmmerTask *                   phmmerTask;
    CreateAnnotationsTask *             createAnnotationsTask;
    
}; // UHMM3PhmmerToAnnotationsTask

} // GB2

#endif // _GB2_UHMMER_PHMMER_TASK_H_
