/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef SOLVENTEXCLUDEDSURFACE_H
#define SOLVENTEXCLUDEDSURFACE_H

#include <molecular_geometry/MolecularSurface.h>

namespace GB2
{

class SolventExcludedSurface : public MolecularSurface
{
public:
    SolventExcludedSurface();
    virtual void calculate(const QList<SharedAtom>& atoms);
    virtual void calculate(const BioStruct3D& bioStruct);
};

class SolventExcludedSurfaceFactory : public MolecularSurfaceFactory
{
public:
    virtual MolecularSurface *createInstance()const;
};

} // namespace

#endif // SOLVENTEXCLUDEDSURFACE_H
