/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_DOC_ACTORS_H_
#define _GB2_WORKFLOW_DOC_ACTORS_H_

#include <workflow/Attribute.h>
#include <workflow/IntegralBusModel.h>
#include <workflow_support/WorkflowUtils.h>
#include <core_api/DocumentFormats.h>

namespace GB2 {
namespace Workflow {

class DocActorProto : public BusActorPrototype {
public:
    DocActorProto(const DocumentFormatId& fid, bool multi, const Descriptor& desc, const QList<PortDescriptor*>& ports, 
        const QList<Attribute*>& attrs = QList<Attribute*>());
    virtual bool isAcceptableDrop(const QMimeData*, QVariantMap*) const;
protected:
    DocumentFormatId fid;
};

class ReadDocPrompter;
typedef PrompterBase<ReadDocPrompter> ReadDocPrompterBase;

class ReadDocPrompter : public ReadDocPrompterBase {
    Q_OBJECT
public:
    ReadDocPrompter(const QString& s) : spec(s) {}
    ReadDocPrompter(Actor* p = 0) : ReadDocPrompterBase(p) {}
    virtual ActorDocument* createDescription(Actor* a) {
        ReadDocPrompter* doc = (ReadDocPrompter*) ReadDocPrompterBase::createDescription(a);
        doc->spec = this->spec;
        return doc;
    }
protected:
    QString composeRichDoc();
    QString spec;
};

class WriteDocPrompter;
typedef PrompterBase<WriteDocPrompter> WriteDocPrompterBase;

class WriteDocPrompter : public WriteDocPrompterBase {
    Q_OBJECT
public:
    WriteDocPrompter(const QString& spec, const QString& slot) : spec(spec), slot(slot) {}
    WriteDocPrompter(Actor* p = 0) : WriteDocPrompterBase(p) {}
    virtual ActorDocument* createDescription(Actor* a) {
        WriteDocPrompter* doc = (WriteDocPrompter*)WriteDocPrompterBase::createDescription(a);
        doc->spec = this->spec;
        doc->slot = this->slot;
        return doc;
    }
protected:
    QString composeRichDoc();
    QString spec,slot;
};

class WriteGenbankPrompter : public PrompterBase<WriteGenbankPrompter> {
    Q_OBJECT
public:
    WriteGenbankPrompter(Actor* p = 0) : PrompterBase<WriteGenbankPrompter>(p) {}
protected:
    QString composeRichDoc();
};

class WriteFastaPrompter : public PrompterBase<WriteFastaPrompter> {
    Q_OBJECT
public:
    WriteFastaPrompter(Actor* p = 0) : PrompterBase<WriteFastaPrompter>(p) {}
protected:
    QString composeRichDoc();
};

}//Workflow namespace
}//GB2 namespace

#endif
