/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_BASEDOC_WORKERS_H_
#define _GB2_WORKFLOW_BASEDOC_WORKERS_H_

#include <workflow_library/LocalDomain.h>

#include <core_api/DocumentFormats.h>

namespace GB2 {

class Document;
class DocumentFormat;

namespace LocalWorkflow {

class LocalDocReader : public BaseWorker {
    Q_OBJECT
public:
    LocalDocReader(Actor* a, const QString& tid, const DocumentFormatId& fid);
    virtual ~LocalDocReader() {}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() ;

protected:
    virtual void doc2data(Document* ) = 0;
protected:
    CommunicationChannel* ch;
    DocumentFormatId fid;
    QMap<Document*, bool> docs;
    bool done, attachDoc2Proj;
    QList<Message> cache;
    DataTypePtr mtype;
};

class LocalDocWriter : public BaseWorker {
    Q_OBJECT
public:
    LocalDocWriter(Actor* a, const DocumentFormatId& fid);
    virtual ~LocalDocWriter(){}
    virtual void init() ;
    virtual bool isReady();
    virtual Task* tick() ;
    virtual bool isDone() ;
    virtual void cleanup() ;

protected:
    virtual void data2doc(Document*, const QVariantMap&) {}
    Task* processDocs();
protected:
    CommunicationChannel* ch;
    DocumentFormat* format;
    QMap<QString, Document*> docs;
    bool done, append;
    QString url;
    QMap<QString, int> counter;
    uint fileMode;
};

class DataWorkerFactory : public DomainFactory {
public:
    DataWorkerFactory(const Descriptor& d) : DomainFactory(d) {}
    virtual ~DataWorkerFactory() {}
    virtual Worker* createWorker(Actor*);
    static void init();
};

}//Workflow namespace
}//GB2 namespace

#endif
