/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_VIEW_CONTROLLER_H_
#define _GB2_WORKFLOW_VIEW_CONTROLLER_H_

#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>

#include <core_api/MainWindow.h>

#include <QtGui/QAction>
#include <QtGui/QGraphicsScene>

class QComboBox;
class QSplitter;
class QDomDocument;
class QListWidget;
class QListWidgetItem;
class QTabWidget;

namespace GB2 {
using namespace Workflow;
class WorkflowView;
class WorkflowScene;
class WorkflowPalette;
class WorkflowEditor;
class WorkflowGObject;
class WorkflowRunTask;

class WorkflowScene : public QGraphicsScene {
    Q_OBJECT
public:
    WorkflowScene(WorkflowView *parent = 0);
    virtual ~WorkflowScene();
    bool isModified() const {return modified;} //FIXME draft support
    bool isLocked() const {return locked;}

    WorkflowRunTask* getRunner() const {return runner;}
    void setRunner(WorkflowRunTask* r) {runner = r;}

    QList<Actor*> getSelectedProcItems() const;
    
    Actor* getActor(ActorId) const;

    Schema getSchema() const;
    QList<Iteration> getIterations() const {return iterations;}
    void setIterations(const QList<Iteration>& lst);

    void addProcess(Actor*, const QPointF&);

public slots:
    void sl_deleteItem();
    void sl_bringToFront();
    void sl_sendToBack();
    void sl_selectAll();
    void sl_reset();
    void setLocked(bool b) {locked = b;}
    void setModified(bool b) {modified = b;}
    void centerView();
    void setHint(int i) {hint=i; update();}

signals:
    void processItemAdded();
    void processDblClicked();
    void configurationChanged();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseMoveEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseDoubleClickEvent(QGraphicsSceneMouseEvent * mouseEvent);
    void contextMenuEvent(QGraphicsSceneContextMenuEvent * contextMenuEvent);

    void dragEnterEvent(QGraphicsSceneDragDropEvent * event);
    void dragMoveEvent(QGraphicsSceneDragDropEvent * event);
    void dropEvent(QGraphicsSceneDragDropEvent * event);

    void drawBackground(QPainter * painter, const QRectF & rect );

private:
    WorkflowView* controller;
    bool modified, locked;
    QList<Iteration> iterations;

    WorkflowRunTask* runner;
    int hint;
};

//class WorkflowView : public GObjectView {
//public:
//virtual QWidget* createWidget();

class WorkflowView : public MWMDIWindow {
    friend class WorkflowScene;
    Q_OBJECT
public:
    WorkflowView(WorkflowGObject* go);
	~WorkflowView();

    //WorkflowDesignerService* getService() const {return service;}

    virtual void setupMDIToolbar(QToolBar* tb);
    virtual void setupViewMenu(QMenu* n);
    void setupContextMenu(QMenu* menu);

    bool confirmModified();

    ActorPrototype* selectedProto() const {
        return currentProc;
    }

    WorkflowScene* getScene() const {return scene;}
    Workflow::Metadata getMeta() const {return meta;}

private slots:
    void sl_editItem();
    void sl_showEditor();
    void sl_selectProcess(Workflow::ActorPrototype*);
    void sl_procItemAdded();
    void sl_rescaleScene(const QString &scale);
    void sl_exportScene();
    void sl_saveScene();
    void sl_saveSceneAs();
    void sl_loadScene();
    void sl_newScene();
    void sl_updateTitle();

	void sl_copyItems();
	void sl_cutItems();
    void sl_pasteItems(const QString& = QString());
    void sl_pasteSample(const QString&);

    void sl_setStyle();
    void sl_toggleStyle();
    void sl_refreshActorDocs();

    bool sl_validate(bool notify = true);
    void sl_pickInfo(QListWidgetItem*);
    void sl_launch();
    void sl_configure();

    void sl_toggleLock(bool = true);

protected:
    bool onCloseEvent();

private:
    void createActions();
    void saveState();

    WorkflowGObject* go;
    WorkflowScene* scene;
    Workflow::Metadata meta;
    ActorPrototype* currentProc;

    QAction* deleteAction;
    QAction* selectAction;
    QAction* bringToFrontAction;
    QAction* sendToBackAction;
    QComboBox* sceneScaleCombo;
    QAction* copyAction;
    QAction* pasteAction;
    QAction* cutAction;

    QString lastPaste;
    int pasteCount;

    QAction* exportAction;
    QAction* saveAction;
    QAction* saveAsAction;
    QAction* loadAction;
    QAction* newAction;
    
    QAction* configureAction;
    QAction* runAction;
    QAction* validateAction;

    QList<QAction*> styleActions;

    QAction* unlockAction;

    QSplitter*      splitter;
    WorkflowPalette* palette;
    WorkflowEditor* propertyEditor;
    QListWidget*    infoList;
    QSplitter*      infoSplitter;
    QTabWidget*     tabs;
};

}//namespace


#endif
