/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WCFG_DIALOG_CONTROLLER_H_
#define _GB2_WCFG_DIALOG_CONTROLLER_H_

#include <ui/ui_SchemaConfigurationDialog.h>
#include <workflow/WorkflowModel.h>
#include <workflow/Schema.h>

namespace GB2 {
class IterationListWidget;
using namespace Workflow;

class SchemaConfigurationDialog : public QDialog,  public Ui_SchemaConfigurationDialog {
    Q_OBJECT
public:
    SchemaConfigurationDialog(const Schema& schema, 
        const QList<Iteration>& lst, QWidget* p = NULL);

    QList<Iteration>& getIterations() const;
    bool hasModifications() const {return modified;}

private slots:
    void finishPropertyEditing();
    void commit();
    void setModified() {modified = true;}

private:
    IterationListWidget* iterationList;
    bool modified;
};

} //namespace

#endif
