/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROXY_DELEGATE_H_
#define _GB2_PROXY_DELEGATE_H_

#include <workflow/ConfigurationEditor.h>
#include <QtGui/QItemDelegate>

Q_DECLARE_METATYPE(GB2::PropertyDelegate*)

namespace GB2 {

enum {
    DelegateRole = Qt::UserRole + 100,
    DescriptorRole
};

class ProxyDelegate : public QItemDelegate {
public:
    ProxyDelegate(QWidget *parent = 0) : QItemDelegate(parent) {}

    virtual void setPropertyValue(const QString& name, QVariant val) const {Q_UNUSED(name); Q_UNUSED(val);}
    virtual bool handlePropertyValueList(const QString& name, QVariant list) const {
        Q_UNUSED(name);Q_UNUSED(list);
        return false;
    }

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const {
        //if (owner->custom) 
        {
            QItemDelegate* d = index.model()->data(index, DelegateRole).value<PropertyDelegate*>();
            if (d) {
                return d->createEditor(parent, option, index);
            }
        }
        return QItemDelegate::createEditor(parent, option, index);
    }

    void setEditorData(QWidget *editor, const QModelIndex &index) const {
        //if (owner->custom) 
        {
            QItemDelegate* d = index.model()->data(index, DelegateRole).value<PropertyDelegate*>();
            if (d) {
                d->setEditorData(editor, index);
                return;
            }
        }
        QItemDelegate::setEditorData(editor, index);
    }

    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const {
        //QTableWidgetItem* item = owner->table->item(index.row(), index.column());
        PropertyDelegate* d = NULL;
        QVariant old;
        QVariant expanded;
        if (/*owner->custom &&*/ (d = model->data(index, DelegateRole).value<PropertyDelegate*>())) {
            old = model->data(index, ConfigurationEditor::ItemValueRole);
            d->setModelData(editor, model, index);
            expanded = model->data(index, ConfigurationEditor::ItemListValueRole);
        } else {
            old = model->data(index, Qt::EditRole);
            QItemDelegate::setModelData(editor, model, index);
        }
        QString name = model->data(index, DescriptorRole).value<Descriptor>().getId();
        if (handlePropertyValueList(name, expanded)) {
            return;
        }
        QVariant val = model->data(index, (d == NULL) ? (int)Qt::EditRole : (int)ConfigurationEditor::ItemValueRole);
        if (val != old) {
            setPropertyValue(name, val);
            if (d) {
                model->setData(index, d->getDisplayValue(val), Qt::DisplayRole);
            }
            model->setData(index, model->data(index, Qt::DisplayRole).toString(), Qt::ToolTipRole);
        }
    }
};

}//namespace
#endif
