/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifdef SW2_BUILD_WITH_CUDA

#ifndef _SMITHWATERMANALGORITHM_CUDA_H
#define _SMITHWATERMANALGORITHM_CUDA_H

#include "SmithWatermanAlgorithm.h"

namespace GB2 {

class SmithWatermanAlgorithmCUDA : public SmithWatermanAlgorithm {
public:
    typedef int ScoreType;

    virtual void launch(SubstMatrix const * _substitutionMatrix, QByteArray const & _patternSeq, QByteArray const & _searchSeq, int _gapOpen, int _gapExtension, int _minScore);
    static quint64 estimateNeededGpuMemory( const SubstMatrix * _substitutionMatrix, QByteArray const & _patternSeq, QByteArray const & _searchSeq );
private:

};


} // namespace

#endif
#endif //SW2_BUILD_WITH_CUDA
